/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.handler;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CompartmentLaneEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;

public class MoveUpHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object firstElement;
        MessageFlowEditor messageFlowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        IStructuredSelection selection = (IStructuredSelection)messageFlowEditor.getSelection();
        if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof EntityEditPart) {
            EntityEditPart editPart = (EntityEditPart)firstElement;
            this.selectUpElement(messageFlowEditor, editPart);
        }
        return null;
    }

    protected void selectUpElement(final MessageFlowEditor messageFlowEditor, final EntityEditPart<? extends MessageFlowEntity> editPart) {
        editPart.getEntity().accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

            public void visitContainer(Container container) {
                MoveUpHandler.this.selectUpContainer(messageFlowEditor, editPart);
            }

            public void visitCompartment(Compartment compartment) {
                MoveUpHandler.this.selectParent(messageFlowEditor, (EditPart)editPart);
            }

            public void visitNestedContainer(NestedContainer nestedContainer) {
                MoveUpHandler.this.selectParent(messageFlowEditor, (EditPart)editPart);
            }

            public void visitCompartmentLane(CompartmentLane lane) {
                MoveUpHandler.this.selectUpElement(messageFlowEditor, (EntityEditPart)editPart.getParent());
            }

            public void visitPatternNode(PatternNode patternNode) {
                int indexOf;
                List compartmentLanes;
                EditPart compartmentEditPart;
                EditPart parent = editPart.getParent();
                if (parent instanceof CompartmentLaneEditPart) {
                    compartmentEditPart = parent.getParent();
                    compartmentLanes = compartmentEditPart.getChildren();
                    indexOf = compartmentLanes.indexOf(parent);
                    if (indexOf > 0) {
                        MoveUpHandler.this.select(messageFlowEditor, (EditPart)compartmentLanes.get(indexOf - 1));
                    } else {
                        MoveUpHandler.this.selectParent(messageFlowEditor, compartmentEditPart);
                    }
                }
                if (parent instanceof NestedContainerEditPart) {
                    compartmentEditPart = parent.getParent();
                    compartmentLanes = compartmentEditPart.getChildren();
                    indexOf = compartmentLanes.indexOf(parent);
                    if (indexOf > 0) {
                        MoveUpHandler.this.select(messageFlowEditor, (EditPart)compartmentLanes.get(indexOf - 1));
                    } else {
                        MoveUpHandler.this.select(messageFlowEditor, compartmentEditPart);
                    }
                }
            }

            public void visitSplitterNode(SplitterNode splitterNode) {
                MoveUpHandler.this.selectParent(messageFlowEditor, (EditPart)editPart);
            }
        });
    }

    protected void selectUpContainer(MessageFlowEditor messageFlowEditor, EntityEditPart<? extends MessageFlowEntity> editPart) {
        List children = editPart.getParent().getChildren();
        int flowIndex = children.indexOf(editPart);
        int botoomFlowIndex = flowIndex > 0 ? flowIndex - 1 : children.size() - 1;
        EditPart element = (EditPart)children.get(botoomFlowIndex);
        this.select(messageFlowEditor, element);
    }

    protected void select(MessageFlowEditor messageFlowEditor, EditPart element) {
        messageFlowEditor.setSelection((ISelection)new StructuredSelection((Object)element));
        messageFlowEditor.getViewer().reveal(element);
    }

    protected void selectParent(MessageFlowEditor messageFlowEditor, EditPart editPart) {
        EditPart parent = editPart.getParent();
        this.select(messageFlowEditor, parent);
    }
}

