/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.handler;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowNavegationUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.utils.ObjectHolder;

public class MoveRightHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object firstElement;
        MessageFlowEditor messageFlowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        IStructuredSelection selection = (IStructuredSelection)messageFlowEditor.getSelection();
        if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof EntityEditPart) {
            EntityEditPart editPart = (EntityEditPart)firstElement;
            this.selectRightElementOf(messageFlowEditor, editPart);
        }
        return null;
    }

    protected void selectRightElementOf(MessageFlowEditor messageFlowEditor, EntityEditPart editPart) {
        EntityEditPart<?> guessElementOnTheRight = this.guessElementOnTheRight(messageFlowEditor, editPart);
        if (guessElementOnTheRight != null) {
            messageFlowEditor.getViewer().reveal(guessElementOnTheRight);
            messageFlowEditor.setSelection((ISelection)new StructuredSelection(guessElementOnTheRight));
        }
    }

    protected EntityEditPart<?> guessInnerRightElement(EditPart childElement) {
        EntityEditPart target = null;
        List children = childElement.getChildren();
        if (!children.isEmpty()) {
            for (Object child : children) {
                EditPart entityEditPart = (EditPart)child;
                List compartmentLaneChildren = entityEditPart.getChildren();
                if (compartmentLaneChildren.isEmpty()) continue;
                target = (EntityEditPart)compartmentLaneChildren.get(0);
                break;
            }
        }
        return target;
    }

    protected EntityEditPart<?> guessElementOnTheRight(final MessageFlowEditor messageFlowEditor, final EntityEditPart<?> editPart) {
        if (editPart == null || !(editPart.getParent() instanceof EntityEditPart)) {
            return null;
        }
        final ObjectHolder target = new ObjectHolder();
        final EntityEditPart parent = (EntityEditPart)editPart.getParent();
        editPart.getEntity().accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

            public void visitCompartment(Compartment compartment) {
                target.set(MoveRightHandler.this.guessElementOnTheRight(messageFlowEditor, parent));
            }

            public void visitCompartmentLane(CompartmentLane lane) {
                target.set(MoveRightHandler.this.guessElementOnTheRight(messageFlowEditor, parent));
            }

            public void visitContainer(Container container) {
            }

            public void visitNestedContainer(NestedContainer nestedContainer) {
                List children = parent.getChildren();
                int indexOf = children.indexOf(editPart);
                if (children.size() > indexOf + 1) {
                    EntityEditPart nestedContainerOnTheLeft = (EntityEditPart)children.get(indexOf + 1);
                    target.set((Object)(nestedContainerOnTheLeft.getChildren().isEmpty() ? nestedContainerOnTheLeft : (EntityEditPart)nestedContainerOnTheLeft.getChildren().get(0)));
                } else {
                    EntityEditPart nestedContainerOnTheLeft = (EntityEditPart)children.get(0);
                    target.set((Object)(nestedContainerOnTheLeft.getChildren().isEmpty() ? nestedContainerOnTheLeft : (EntityEditPart)nestedContainerOnTheLeft.getChildren().get(0)));
                }
            }
        });
        if (target.isNull()) {
            EntityEditPart<? extends MessageFlowEntity> rightEditPart = MessageFlowNavegationUtils.getNextFlowEditPart(editPart);
            if (rightEditPart != null) {
                target.set(rightEditPart);
            } else {
                target.set(this.guessElementOnTheRight(messageFlowEditor, parent));
            }
        }
        return (EntityEditPart)target.get();
    }
}

