/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.handler;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowNavegationUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.utils.ObjectHolder;

public class MoveLeftHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object firstElement;
        MessageFlowEditor messageFlowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        IStructuredSelection selection = (IStructuredSelection)messageFlowEditor.getSelection();
        if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof EntityEditPart && !MessageFlowUtils.isFlowOrSubflowEditPart((EditPart)firstElement)) {
            EntityEditPart editPart = (EntityEditPart)firstElement;
            this.selectLeftElementOf(messageFlowEditor, (EditPart)editPart);
        }
        return null;
    }

    protected void selectLeftElementOf(MessageFlowEditor messageFlowEditor, EditPart editPart) {
        ObjectHolder target = new ObjectHolder();
        EntityEditPart<? extends MessageFlowEntity> leftEditPart = MessageFlowNavegationUtils.getPreviousFlowEditPart((EntityEditPart)editPart);
        if (target.isNull()) {
            if (leftEditPart != null) {
                target.set(leftEditPart);
            } else {
                target.set(this.guessElementOnTheLeft(messageFlowEditor, editPart.getParent()));
            }
        }
        if (!target.isNull()) {
            messageFlowEditor.getViewer().reveal((EditPart)target.get());
            messageFlowEditor.setSelection((ISelection)new StructuredSelection(target.get()));
        }
    }

    protected EntityEditPart<?> guessInnerLeftElement(EditPart childElement) {
        EntityEditPart target = null;
        List children = childElement.getChildren();
        if (!children.isEmpty()) {
            for (Object child : children) {
                EditPart entityEditPart = (EditPart)child;
                List compartmentLaneChildren = entityEditPart.getChildren();
                if (compartmentLaneChildren.isEmpty()) continue;
                target = (EntityEditPart)compartmentLaneChildren.get(compartmentLaneChildren.size() - 1);
                break;
            }
        }
        return target;
    }

    protected EntityEditPart<?> guessElementOnTheLeft(final MessageFlowEditor messageFlowEditor, EditPart editPart) {
        final ObjectHolder target = new ObjectHolder();
        if (editPart instanceof EntityEditPart) {
            final EntityEditPart entityEditPart = (EntityEditPart)editPart;
            entityEditPart.getEntity().accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

                public void visitContainer(Container container) {
                    ContainerEditPart containerEditPart = (ContainerEditPart)entityEditPart;
                    List lanes = containerEditPart.getChildren();
                    if (!lanes.isEmpty()) {
                        target.set(MoveLeftHandler.this.guessElementOnTheLeft(messageFlowEditor, (EditPart)lanes.get(lanes.size() - 1)));
                    } else {
                        target.set((Object)containerEditPart);
                    }
                }

                public void visitNestedContainer(NestedContainer nestedContainer) {
                    List brothers = entityEditPart.getParent().getChildren();
                    int indexOf = brothers.indexOf(entityEditPart);
                    EntityEditPart leftNestedContainer = indexOf - 1 >= 0 ? (EntityEditPart)brothers.get(indexOf - 1) : (EntityEditPart)brothers.get(brothers.size() - 1);
                    List children = leftNestedContainer.getChildren();
                    if (CollectionUtils.isNotEmpty((Collection)children)) {
                        target.set((Object)((EntityEditPart)children.get(children.size() - 1)));
                    }
                }

                public void visitCompartment(Compartment compartment) {
                    target.set(MoveLeftHandler.this.guessElementOnTheLeft(messageFlowEditor, entityEditPart.getParent()));
                }

                public void visitCompartmentLane(CompartmentLane lane) {
                    List brothers = entityEditPart.getParent().getChildren();
                    int indexOf = brothers.indexOf(entityEditPart);
                    EntityEditPart leftNestedContainer = indexOf - 1 >= 0 ? (EntityEditPart)brothers.get(indexOf - 1) : (EntityEditPart)brothers.get(brothers.size() - 1);
                    List children = leftNestedContainer.getChildren();
                    target.set((Object)((EntityEditPart)children.get(children.size() - 1)));
                }
            });
        }
        return (EntityEditPart)target.get();
    }
}

