/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.handler;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CompartmentLaneEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;

public class MoveDownHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object firstElement;
        MessageFlowEditor messageFlowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        IStructuredSelection selection = (IStructuredSelection)messageFlowEditor.getSelection();
        if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof EntityEditPart) {
            EntityEditPart editPart = (EntityEditPart)firstElement;
            this.selectDownElement(messageFlowEditor, editPart);
        }
        return null;
    }

    protected void selectDownElement(final MessageFlowEditor messageFlowEditor, final EntityEditPart<? extends MessageFlowEntity> editPart) {
        editPart.getEntity().accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

            public void visitContainer(Container container) {
                MoveDownHandler.this.selectDownContainer(messageFlowEditor, editPart);
            }

            public void visitCompartment(Compartment compartment) {
                MoveDownHandler.this.selectFirstChild(messageFlowEditor, editPart);
            }

            public void visitCompartmentLane(CompartmentLane lane) {
                CompartmentLaneEditPart laneEditPart = (CompartmentLaneEditPart)editPart;
                List children = laneEditPart.getChildren();
                if (!children.isEmpty()) {
                    MoveDownHandler.this.select(messageFlowEditor, (EditPart)children.get(0));
                }
            }

            public void visitNestedContainer(NestedContainer nestedContainer) {
                List children = editPart.getChildren();
                if (!children.isEmpty()) {
                    MoveDownHandler.this.select(messageFlowEditor, (EditPart)children.get(0));
                }
            }

            public void visitPatternNode(PatternNode patternNode) {
                EditPart parent = editPart.getParent();
                if (parent instanceof CompartmentLaneEditPart) {
                    EditPart compartmentEditPart = parent.getParent();
                    List compartmentLanes = compartmentEditPart.getChildren();
                    int indexOf = compartmentLanes.indexOf(parent);
                    if (indexOf < compartmentLanes.size() - 1) {
                        MoveDownHandler.this.select(messageFlowEditor, (EditPart)compartmentLanes.get(indexOf + 1));
                    } else {
                        MoveDownHandler.this.select(messageFlowEditor, (EditPart)compartmentLanes.get(0));
                    }
                }
            }

            public void visitSplitterNode(SplitterNode splitterNode) {
                MoveDownHandler.this.selectFirstChild(messageFlowEditor, editPart);
            }
        });
    }

    protected void selectDownContainer(MessageFlowEditor messageFlowEditor, EntityEditPart<? extends MessageFlowEntity> editPart) {
        EditPart parent = editPart.getParent();
        boolean isTopLevelContainer = parent instanceof MuleConfigurationEditPart;
        if (isTopLevelContainer) {
            List children = parent.getChildren();
            int flowIndex = children.indexOf(editPart);
            int botoomFlowIndex = flowIndex == children.size() - 1 ? 0 : flowIndex + 1;
            EditPart element = (EditPart)children.get(botoomFlowIndex);
            this.select(messageFlowEditor, element);
        } else {
            this.selectFirstChild(messageFlowEditor, editPart);
        }
    }

    protected void select(MessageFlowEditor messageFlowEditor, EditPart element) {
        messageFlowEditor.setSelection((ISelection)new StructuredSelection((Object)element));
        messageFlowEditor.getViewer().reveal(element);
    }

    protected void selectFirstChild(MessageFlowEditor messageFlowEditor, EntityEditPart<? extends MessageFlowEntity> editPart) {
        List children = editPart.getChildren();
        if (!children.isEmpty()) {
            EntityEditPart firstChild = (EntityEditPart)children.get(0);
            this.selectDownElement(messageFlowEditor, firstChild);
        }
    }
}

