/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.handler;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.PartInitException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.handler.IGoToImplementationHandler;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.ui.utils.UiUtils;

public class GoToJavaClassHandler
implements IGoToImplementationHandler {
    @Override
    public void execute(MessageFlowNode messageFlowNode) {
        try {
            IFile classFile = this.getClassFile(messageFlowNode);
            if (classFile != null) {
                UiUtils.openEditorForFile((IFile)classFile);
            }
        }
        catch (JavaModelException | PartInitException e) {
            MuleCorePlugin.logError((String)"Cannot open Java class", (Throwable)e);
            e.printStackTrace();
        }
    }

    private IFile getClassFile(MessageFlowNode messageFlowNode) throws JavaModelException {
        IJavaProject javaProject;
        IType type;
        String className;
        IReadOnlyProperty classProperty = (IReadOnlyProperty)messageFlowNode.getProperties().getProperty("class");
        if (classProperty != null && !StringUtils.isEmpty((String)(className = classProperty.getValue())) && (type = (javaProject = MuleCorePlugin.getDesignContext().getMuleProject().getJavaProject()).findType(className)) != null) {
            IResource resource = type.getResource();
            return (IFile)resource;
        }
        return null;
    }
}

