/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.handler;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.easter.GameDialog;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.ui.MuleImages;

public class FilteredFlowsSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String EDITOR_ID = "org.mule.tooling.messageflow.messageFlowEditor";

    public FilteredFlowsSelectionDialog(Shell shell) {
        super(shell, false);
        this.setTitle("Open Flow");
        this.setDetailsLabelProvider(new DetailsLabelProvider());
        this.setListLabelProvider(new LabelProvider());
    }

    protected void fillContentProvider(final FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, final FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask("Getting Projects", 15);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        progressMonitor.beginTask("Loading Flows", 85);
        if (projects.length > 0) {
            int partSize = 85 / projects.length;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IMuleProject muleProject;
                IProject iProject = iProjectArray[n2];
                if (iProject.isOpen() && CoreUtils.hasMuleNature((IProject)iProject) && (muleProject = MuleRuntime.create((IProject)iProject)) != null) {
                    StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            List configurations = muleProject.getConfigurationsCache().getConfigurations();
                            for (MuleConfiguration muleConfiguration : configurations) {
                                List flows = muleConfiguration.getFlows();
                                for (Container flow : flows) {
                                    ContentProviderItem item = new ContentProviderItem(flow, muleProject);
                                    if (!itemsFilter.matchItem((Object)item)) continue;
                                    contentProvider.add((Object)item, itemsFilter);
                                }
                            }
                            return null;
                        }
                    }, (IMuleProject)muleProject);
                }
                progressMonitor.worked(partSize);
                ++n2;
            }
        }
        progressMonitor.done();
    }

    protected void okPressed() {
        this.computeResult();
        Object[] result = this.getResult();
        if (result.length == 1 && result[0] instanceof ContentProviderItem) {
            final ContentProviderItem selected = (ContentProviderItem)result[0];
            StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    IFile configurationFile = selected.getProject().getConfigurationsCache().searchConfigurationFileByFlow(selected.getFlow());
                    if (configurationFile != null) {
                        FilteredFlowsSelectionDialog.this.openEditor(configurationFile, selected.getFlow());
                        FilteredFlowsSelectionDialog.this.setReturnCode(0);
                        FilteredFlowsSelectionDialog.this.close();
                    }
                    return null;
                }
            }, (IMuleProject)selected.getProject());
        }
    }

    private void openEditor(IFile configFile, Container selected) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        MultiPageMessageFlowEditor openEditor = (MultiPageMessageFlowEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)configFile, (String)EDITOR_ID);
        try {
            MessageFlowEditor flowEditor = (MessageFlowEditor)openEditor.getActiveEditor();
            this.scrollToFlow(selected, flowEditor);
        }
        catch (Exception exception) {}
    }

    private void scrollToFlow(Container selected, MessageFlowEditor flowEditor) {
        EntityEditPart<?> editPart = this.findPart(flowEditor.getViewer(), selected);
        if (editPart != null) {
            flowEditor.getViewer().reveal(editPart);
            flowEditor.setSelection((ISelection)new StructuredSelection(editPart));
        }
    }

    private EntityEditPart<?> findPart(GraphicalViewer viewer, Container selected) {
        Map registry = viewer.getEditPartRegistry();
        for (Object current : registry.keySet()) {
            Container currentFlow;
            EntityDecorator decorator;
            IMessageFlowEntity entity;
            if (!(current instanceof EntityDecorator) || !((entity = (decorator = (EntityDecorator)current).getEntity()) instanceof MessageFlowEntity) || !ModelUtils.isFlowOrSubflow((IMessageFlowEntity)((MessageFlowEntity)entity)) || !(currentFlow = (Container)entity).getName().equals(selected.getName())) continue;
            return (EntityEditPart)registry.get(current);
        }
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FlowFilter();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        DialogSettings dialogSettings = new DialogSettings("DialogBoundsSettings");
        dialogSettings.put("ShowStatusLine", true);
        return dialogSettings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected Comparator<ContentProviderItem> getItemsComparator() {
        return new Comparator<ContentProviderItem>(){

            @Override
            public int compare(ContentProviderItem arg0, ContentProviderItem arg1) {
                return arg0.getId().compareTo(arg1.getId());
            }
        };
    }

    public String getElementName(Object item) {
        ContentProviderItem flow = (ContentProviderItem)item;
        return flow.getId();
    }

    protected Control createContents(Composite parent) {
        Control createContents = super.createContents(parent);
        this.getPatternControl().addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if ("fefewearegonnamissyou".equals(((Text)FilteredFlowsSelectionDialog.this.getPatternControl()).getText())) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                GameDialog gameDialog = new GameDialog();
                                gameDialog.open();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
        return createContents;
    }

    private class ContentProviderItem {
        private Container flow;
        private IMuleProject project;

        public ContentProviderItem(Container flow, IMuleProject project) {
            this.flow = flow;
            this.project = project;
        }

        public Container getFlow() {
            return this.flow;
        }

        public IMuleProject getProject() {
            return this.project;
        }

        public String getId() {
            return (String)StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ContentProviderItem.this.flow.getName();
                }
            }, (IMuleProject)this.project, (Object)"");
        }
    }

    private class DetailsLabelProvider
    extends LabelProviderAdapter {
        private DetailsLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (!(element instanceof ContentProviderItem)) {
                return "";
            }
            Container flow = ((ContentProviderItem)element).getFlow();
            String description = flow.getDescription();
            return StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)description), (int)100);
        }
    }

    private class FlowFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private FlowFilter() {
            super((FilteredItemsSelectionDialog)FilteredFlowsSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            if (StringUtils.isBlank((String)this.getPattern())) {
                return true;
            }
            ContentProviderItem flow = (ContentProviderItem)item;
            return this.matches(flow.getId());
        }

        public boolean isConsistentItem(Object item) {
            Container flow = ((ContentProviderItem)item).getFlow();
            return flow != null && flow.getName() != null;
        }
    }

    private class LabelProvider
    extends LabelProviderAdapter
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private LabelProvider() {
        }

        @Override
        public Image getImage(Object element) {
            return MuleImages.FLOW_IMAGE;
        }

        @Override
        public String getText(Object element) {
            if (element == null || !(element instanceof ContentProviderItem)) {
                return "";
            }
            ContentProviderItem item = (ContentProviderItem)element;
            return item.getId();
        }

        public StyledString getStyledText(Object element) {
            if (element == null || !(element instanceof ContentProviderItem)) {
                return new StyledString("");
            }
            StyledString styledString = new StyledString(this.getText(element));
            ContentProviderItem item = (ContentProviderItem)element;
            String projectName = item.getProject().getName();
            styledString.append(" from " + projectName, StyledString.createColorRegistryStyler((String)"QUALIFIER_COLOR", null));
            return styledString;
        }
    }

    private class LabelProviderAdapter
    implements ILabelProvider {
        private LabelProviderAdapter() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

