/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figuredecorator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.mule.tooling.core.utils.Tuple3;
import org.mule.tooling.messageflow.figuredecorator.CompositeFigureDecoratorImageDescriptor;
import org.mule.tooling.messageflow.figuredecorator.CompositeMouseListener;

public class OverlayIcon {
    private List<Tuple3<ImageDescriptor, MouseListener, Integer>> tuples;
    private Tuple3<ImageDescriptor, MouseListener, Integer> compositeTuple;

    public OverlayIcon(ImageDescriptor imageDescriptor, MouseListener listener) {
        Tuple3 tuple = new Tuple3((Object)imageDescriptor, (Object)listener, (Object)Integer.MAX_VALUE);
        this.tuples = Collections.singletonList(tuple);
    }

    public OverlayIcon(ImageDescriptor imageDescriptor, MouseListener listener, int order) {
        Tuple3 tuple = new Tuple3((Object)imageDescriptor, (Object)listener, (Object)order);
        this.tuples = Collections.singletonList(tuple);
    }

    public OverlayIcon(Collection<OverlayIcon> overlays) {
        overlays.removeAll(Collections.singleton(null));
        ArrayList<Tuple3<ImageDescriptor, MouseListener, Integer>> tuples = new ArrayList<Tuple3<ImageDescriptor, MouseListener, Integer>>();
        for (OverlayIcon overlayIcon : overlays) {
            tuples.addAll(overlayIcon.getAllImageTuples());
        }
        Collections.sort(tuples, new ImageTupleComparator());
        this.tuples = tuples;
    }

    public List<Tuple3<ImageDescriptor, MouseListener, Integer>> getAllImageTuples() {
        return this.tuples;
    }

    public Tuple3<ImageDescriptor, MouseListener, Integer> getImageTuple() {
        if (this.compositeTuple == null) {
            ArrayList<ImageDescriptor> imageDescriptors = new ArrayList<ImageDescriptor>();
            ArrayList<MouseListener> listeners = new ArrayList<MouseListener>();
            for (Tuple3<ImageDescriptor, MouseListener, Integer> tuple : this.tuples) {
                imageDescriptors.add((ImageDescriptor)tuple.first());
                listeners.add((MouseListener)tuple.second());
            }
            CompositeMouseListener mouseListener = new CompositeMouseListener(listeners);
            ImageDescriptor compositeImgDesc = CompositeFigureDecoratorImageDescriptor.create(imageDescriptors);
            this.compositeTuple = new Tuple3((Object)compositeImgDesc, (Object)mouseListener, (Object)-1);
        }
        return this.compositeTuple;
    }

    public ImageDescriptor getImageDescriptor() {
        return (ImageDescriptor)this.getImageTuple().first();
    }

    public MouseListener getMouseListener() {
        return (MouseListener)this.getImageTuple().second();
    }

    public static final class ImageTupleComparator
    implements Comparator<Tuple3<ImageDescriptor, MouseListener, Integer>> {
        @Override
        public int compare(Tuple3<ImageDescriptor, MouseListener, Integer> o1, Tuple3<ImageDescriptor, MouseListener, Integer> o2) {
            return ((Integer)o1.third()).compareTo((Integer)o2.third());
        }
    }
}

