/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figuredecorator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.messageflow.figuredecorator.CompositeFigureDecorator;
import org.mule.tooling.messageflow.figuredecorator.DefaultFigureDecorator;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecorator;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecoratorFactory;
import org.mule.tooling.messageflow.util.MessageFlowEntityWrapper;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.utils.UtilsPlugin;

public final class FigureDecoratorFactoryManager {
    private static final DefaultFigureDecorator DEFAULT_FIGURE_DECORATOR = new DefaultFigureDecorator(null, null, null, null);
    private List<IFigureDecoratorFactory> decoratorFactories;

    private FigureDecoratorFactoryManager() {
        this.initializeFactories();
    }

    public static final FigureDecoratorFactoryManager getDefault() {
        return SingletonHolder.INSTANCE;
    }

    private void initializeFactories() {
        IConfigurationElement[] configurationElementsFor;
        this.decoratorFactories = new ArrayList<IFigureDecoratorFactory>();
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.figuredecorator");
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                this.decoratorFactories.add((IFigureDecoratorFactory)iConfigurationElement.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public IFigureDecorator createDecorator(MessageFlowEntity entity) {
        ArrayList<IFigureDecorator> decorators = new ArrayList<IFigureDecorator>(this.decoratorFactories.size());
        if (!this.decoratorFactories.isEmpty()) {
            MessageFlowEntityWrapper wrapper = new MessageFlowEntityWrapper(entity);
            for (IFigureDecoratorFactory decoratorFactory : this.decoratorFactories) {
                IFigureDecorator decorator;
                if (!decoratorFactory.decorates(entity) || (decorator = this.createDecorator(wrapper, decoratorFactory)) == null) continue;
                decorators.add(decorator);
            }
        }
        if (decorators.isEmpty()) {
            return DEFAULT_FIGURE_DECORATOR;
        }
        if (decorators.size() == 1) {
            return (IFigureDecorator)decorators.get(0);
        }
        return new CompositeFigureDecorator(decorators);
    }

    private IFigureDecorator createDecorator(MessageFlowEntityWrapper wrapper, IFigureDecoratorFactory decoratorFactory) {
        IFigureDecorator figureDecorator = null;
        try {
            figureDecorator = decoratorFactory.createDecorator(wrapper);
        }
        catch (Exception e) {
            UtilsPlugin.logError((String)"Unexpected error.", (Throwable)e);
        }
        return figureDecorator;
    }

    private static final class SingletonHolder {
        private static final FigureDecoratorFactoryManager INSTANCE = new FigureDecoratorFactoryManager();

        private SingletonHolder() {
        }
    }
}

