/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figuredecorator;

import java.util.Collections;
import java.util.List;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorPosition;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecorator;
import org.mule.tooling.messageflow.figuredecorator.OverlayIcon;

public class DefaultFigureDecorator
implements IFigureDecorator {
    private OverlayIcon bottomLeft;
    private OverlayIcon topLeft;
    private OverlayIcon topRight;
    private OverlayIcon bottomRight;

    public DefaultFigureDecorator(OverlayIcon bottomLeft, OverlayIcon topLeft, OverlayIcon topRight, OverlayIcon bottomRight) {
        this.bottomLeft = bottomLeft;
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
    }

    public DefaultFigureDecorator() {
    }

    @Override
    public OverlayIcon getOverlay(FigureDecoratorPosition pos) {
        switch (pos) {
            case BOTTOM_LEFT: {
                return this.bottomLeft;
            }
            case BOTTOM_RIGHT: {
                return this.bottomRight;
            }
            case TOP_LEFT: {
                return this.topLeft;
            }
            case TOP_RIGHT: {
                return this.topRight;
            }
            case OUTSIDE: {
                return null;
            }
        }
        throw new RuntimeException("Invalid figure decorator position");
    }

    @Override
    public List<OverlayIcon> getOverlayList(FigureDecoratorPosition pos) {
        switch (pos) {
            case BOTTOM_LEFT: {
                return Collections.singletonList(this.bottomLeft);
            }
            case BOTTOM_RIGHT: {
                return Collections.singletonList(this.bottomRight);
            }
            case TOP_LEFT: {
                return Collections.singletonList(this.topLeft);
            }
            case TOP_RIGHT: {
                return Collections.singletonList(this.topRight);
            }
        }
        throw new RuntimeException("Invalid figure decorator position");
    }
}

