/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.function.Supplier;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.mule.tooling.icons.ImageUtils;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.FigureImageRegistry;
import org.mule.tooling.messageflow.figure.ParagraphTextFlowLabel;
import org.mule.tooling.messageflow.figure.TextFlowLabel;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.UnknownNode;

public class UnknownFigure
extends EntityFigure<UnknownNode> {
    private ImageFigure imageFigure;
    private TextFlowLabel label;

    public UnknownFigure(UnknownNode node) {
        super(node);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        layout.setSpacing(5);
        this.setLayoutManager((LayoutManager)layout);
        Image image = ImagesManager.getInstance().getCanvasUnknown();
        Supplier<Image> imageProvider = () -> new Image(image.getDevice(), ImageUtils.convertToGray((ImageData)image.getImageData()));
        Image grayImage = FigureImageRegistry.getDefault().getImage("gray-" + UnknownFigure.class.getSimpleName(), imageProvider);
        this.imageFigure = new ImageFigure(grayImage);
        this.add((IFigure)this.imageFigure);
        this.label = new ParagraphTextFlowLabel(MessageFlowUtils.getUnknownName(node));
        this.add((IFigure)this.label);
        this.setBorder((Border)new MarginBorder(2));
        this.setToolTip((IFigure)new Label(((UnknownNode)this.getEntity()).getContent()));
        this.applyStyle();
    }

    @Override
    protected void severityChanged() {
    }

    @Override
    public boolean hasLabel() {
        return true;
    }

    @Override
    public void updateLabel(String value) {
        this.label.setText(value);
    }

    @Override
    public synchronized TextFlowLabel getLabel() {
        return this.label;
    }

    @Override
    public String getLabelText() {
        return this.label.getText();
    }

    @Override
    public void setLabelText(String value) {
        this.label.setText(value);
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
        visitor.visitUnknown(this);
    }
}

