/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;

public class TopLineColoredBorder
extends LineBorder {
    private Color topBorderColor;

    public TopLineColoredBorder(Color borderColor, int borderWidth) {
        super(borderColor, borderWidth);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        super.paint(figure, graphics, insets);
        if (this.topBorderColor != null) {
            int width = 2;
            graphics.setLineWidth(width);
            graphics.setForegroundColor(this.topBorderColor);
            Point topLeft = tempRect.getTopLeft();
            Point topRight = tempRect.getTopRight();
            topLeft.y += width / 2;
            topRight.y += width / 2;
            ++topRight.x;
            graphics.drawLine(topLeft, topRight);
        }
    }

    public Color getTopBorderColor() {
        return this.topBorderColor;
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.topBorderColor = topBorderColor;
    }
}

