/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;
import org.mule.tooling.messageflow.figure.ICssAwareFigure;

public abstract class TextFlowLabel
extends Figure
implements ICssAwareFigure {
    public static final int LABEL_MAXIMUM_WIDTH = 100;
    private TextFlow textFlow;
    private FlowPage flowPage;
    private String cssClass = "";
    private String cssId = "";

    public TextFlowLabel() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.textFlow = new TextFlow();
        this.textFlow.setForegroundColor(FigureColorRegistry.getDefault().get("container.font.color"));
        this.flowPage = new FlowPage();
        this.flowPage.setHorizontalAligment(2);
        this.setTextFlowLayoutManager();
        this.flowPage.add((IFigure)this.textFlow);
        this.add((IFigure)this.flowPage);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        super.paintFigure(graphics);
    }

    abstract void setTextFlowLayoutManager();

    public TextFlow getTextFlow() {
        return this.textFlow;
    }

    public TextFlowLabel(String s) {
        this();
        this.textFlow.setText(s);
    }

    public String getText() {
        return this.textFlow.getText();
    }

    public void setText(String s) {
        this.textFlow.setText(s);
    }

    public void setTextLayout(LayoutManager layout) {
        this.textFlow.setLayoutManager(layout);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int prefWidth = this.flowPage.getPreferredSize().width;
        if (this.flowPage.getChildren() != null && !this.flowPage.getChildren().isEmpty() && ((IFigure)this.flowPage.getChildren().get(0)).toString().contains("Error handler reference")) {
            return super.getPreferredSize(wHint, hHint);
        }
        if (prefWidth < 100 && prefWidth > -1) {
            return super.getPreferredSize(wHint, hHint);
        }
        return super.getPreferredSize(100, hHint);
    }

    @Override
    public String getCssClass() {
        return this.cssClass;
    }

    @Override
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    public String getCssId() {
        return this.cssId;
    }

    @Override
    public void setCssId(String id) {
        this.cssId = id;
    }
}

