/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;
import org.mule.tooling.messageflow.figure.PatternFigure;
import org.mule.tooling.messageflow.figure.SplitterSimpleBorder;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorFactoryManager;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecorator;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;

public class SplitterPatternFigure
extends EntityFigure<PatternNode> {
    private PatternFigure patternFigure;
    private CompoundBorder compoundBorder;
    private SplitterSimpleBorder splitterBorder;
    private SplitterNode splitter;

    public SplitterPatternFigure(PatternNode pattern, SplitterNode splitter) {
        super(pattern);
        this.splitter = splitter;
        this.patternFigure = new PatternFigure(pattern);
        FlowLayout layout = new FlowLayout(false);
        layout.setMajorAlignment(0);
        this.setLayoutManager((LayoutManager)layout);
        this.add((IFigure)this.patternFigure);
        this.setBackgroundColor(this.getSplitterBackground());
        this.createBorder();
        this.applyStyle();
    }

    public void createBorder() {
        this.setSplitterBorder(new SplitterSimpleBorder(this.getBorderColor()));
        this.setCompoundBorder(new CompoundBorder((Border)this.getSplitterBorder(), (Border)new MarginBorder(2)));
        this.setBorder((Border)this.getCompoundBorder());
    }

    private Color getSplitterBackground() {
        return FigureColorRegistry.getDefault().get("splitter.pattern.background");
    }

    protected Color getBorderColor() {
        return FigureColorRegistry.getDefault().get("splitter.pattern.border");
    }

    @Override
    public void setSeverity(int severity) {
        this.patternFigure.setSeverity(severity);
        super.setSeverity(severity);
    }

    @Override
    public void updateImageFigure() {
        this.patternFigure.updateImageFigure((MessageFlowEntity)this.splitter);
        IFigureDecorator decorator = FigureDecoratorFactoryManager.getDefault().createDecorator((MessageFlowEntity)this.splitter);
        this.setFigureDecorator(decorator);
    }

    @Override
    protected void setFigureDecorator(IFigureDecorator decorator) {
        super.setFigureDecorator(decorator);
        this.patternFigure.setFigureDecorator(decorator);
    }

    @Override
    protected void severityChanged() {
        this.updateImageFigure();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension pref = super.getPreferredSize(wHint, hHint);
        return new Dimension(pref.width, Math.max(hHint, pref.height));
    }

    public PatternFigure getPatternFigure() {
        return this.patternFigure;
    }

    @Override
    public boolean hasLabel() {
        return true;
    }

    @Override
    public Figure getLabel() {
        return this.patternFigure.getLabel();
    }

    @Override
    public String getLabelText() {
        return this.patternFigure.getLabelText();
    }

    @Override
    public void setLabelText(String value) {
        this.patternFigure.setLabelText(value);
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
        visitor.visitSplitterPattern(this);
    }

    public CompoundBorder getCompoundBorder() {
        return this.compoundBorder;
    }

    private void setCompoundBorder(CompoundBorder lineWithMargin) {
        this.compoundBorder = lineWithMargin;
    }

    public SplitterSimpleBorder getSplitterBorder() {
        return this.splitterBorder;
    }

    private void setSplitterBorder(SplitterSimpleBorder splitterBorder) {
        this.splitterBorder = splitterBorder;
    }
}

