/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.swt.graphics.Color;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;
import org.mule.tooling.messageflow.figure.GreedyFlowLayout;
import org.mule.tooling.messageflow.figure.SplitterPatternFigure;
import org.mule.tooling.model.messageflow.SplitterNode;

public class SplitterFigure
extends EntityFigure<SplitterNode> {
    private SplitterPatternFigure splitterPatternFigure;
    private LineBorder lineBorder;

    public SplitterFigure(SplitterNode node) {
        super(node);
        this.createBorder();
        GreedyFlowLayout layout = new GreedyFlowLayout(true);
        layout.setMinorAlignment(0);
        layout.setMinorSpacing(35);
        this.setLayoutManager((LayoutManager)layout);
        this.applyStyle();
    }

    public void createBorder() {
        this.setLineBorder(new LineBorder(this.getBorderColor(), 1));
        this.getLineBorder().setStyle(1);
        this.setBorder((Border)this.getLineBorder());
    }

    private Color getBorderColor() {
        return FigureColorRegistry.getDefault().get("splitter.border");
    }

    @Override
    protected void severityChanged() {
    }

    @Override
    public void setSeverity(int severity) {
        super.setSeverity(severity);
        SplitterPatternFigure patternFigure = this.getSplitterPatternFigure();
        patternFigure.setSeverity(severity);
    }

    @Override
    public boolean hasLabel() {
        return true;
    }

    @Override
    public Figure getLabel() {
        SplitterPatternFigure patternFigure = this.getSplitterPatternFigure();
        return patternFigure.getLabel();
    }

    @Override
    public String getLabelText() {
        SplitterPatternFigure patternFigure = this.getSplitterPatternFigure();
        return patternFigure.getLabelText();
    }

    @Override
    public void setLabelText(String value) {
        SplitterPatternFigure patternFigure = this.getSplitterPatternFigure();
        patternFigure.setLabelText(value);
    }

    @Override
    public void updateLabel(String value) {
        this.setLabelText(value);
    }

    protected SplitterPatternFigure getSplitterPatternFigure() {
        if (this.splitterPatternFigure != null) {
            return this.splitterPatternFigure;
        }
        List entityFigures = this.getChildren();
        for (IFigure entity : entityFigures) {
            if (!(entity instanceof SplitterPatternFigure)) continue;
            this.splitterPatternFigure = (SplitterPatternFigure)entity;
            return (SplitterPatternFigure)entity;
        }
        return null;
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
        visitor.visitSplitter(this);
    }

    public LineBorder getLineBorder() {
        return this.lineBorder;
    }

    private void setLineBorder(LineBorder lineBorder) {
        this.lineBorder = lineBorder;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.getSplitterPatternFigure().paint(graphics);
    }
}

