/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.utils.Tuple3;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;
import org.mule.tooling.messageflow.figure.GreedyFlowLayout;
import org.mule.tooling.messageflow.figure.ParagraphTextFlowLabel;
import org.mule.tooling.messageflow.figure.TextFlowLabel;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorPosition;
import org.mule.tooling.messageflow.figuredecorator.OverlayIcon;
import org.mule.tooling.model.messageflow.MessageFlowEntity;

public class ScopeFigure
extends EntityFigure<MessageFlowEntity> {
    public static final String TRANSACTION_DEMARCATION_COLOR = "transaction.demarcation.color";
    private LineBorder lineBorderOne;
    private LineBorder lineBorderTwo;
    protected int preferredEmptyWidth = 80;
    protected int preferredEmptyHeight = 80;
    protected TextFlowLabel typeLabel;
    private Label titleLabel;
    protected Figure contentFigure;
    private Figure titleFigure;
    private boolean rollback;
    private boolean redelivery;
    private boolean isCoreRollback;
    protected boolean allowsDirectEditing = true;
    private List<Image> createdImages = new ArrayList<Image>();

    public Figure getContentFigure() {
        return this.contentFigure;
    }

    public ScopeFigure(MessageFlowEntity scope, boolean allowEdit) {
        super(scope);
        ToolbarLayout tbLayout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)tbLayout);
        this.setTitleFigure(new Figure());
        FlowLayout flowLayout = new FlowLayout(true);
        flowLayout.setStretchMinorAxis(true);
        this.getTitleFigure().setLayoutManager((LayoutManager)flowLayout);
        this.typeLabel = new ParagraphTextFlowLabel();
        this.typeLabel.setForegroundColor(ColorConstants.gray);
        this.getTitleFigure().add((IFigure)this.typeLabel);
        this.setTitleLabel(new Label());
        this.getTitleLabel().setForegroundColor(ColorConstants.black);
        this.getTitleFigure().add((IFigure)this.getTitleLabel());
        this.getTitleFigure().setOpaque(true);
        this.getTitleFigure().setBackgroundColor(this.getTitleColor());
        boolean noTitle = false;
        this.redelivery = false;
        this.rollback = false;
        MarginBorder titleMargin = new MarginBorder(1, 3, 1, 3);
        if (!noTitle) {
            this.getTitleFigure().setBorder((Border)titleMargin);
            super.add((IFigure)this.getTitleFigure(), null, -1);
        }
        this.contentFigure = new Figure();
        if (this.rollback || this.isCoreRollback) {
            layout = new ToolbarLayout(false);
            layout.setStretchMinorAxis(true);
            this.contentFigure.setLayoutManager((LayoutManager)layout);
        } else {
            layout = new GreedyFlowLayout(false);
            this.contentFigure.setLayoutManager((LayoutManager)layout);
        }
        MarginBorder margin = new MarginBorder(this.rollback ? 0 : 5);
        this.contentFigure.setBorder((Border)margin);
        this.addContentFigure();
        this.createBorder(false);
        this.updateImageFigure();
    }

    public void createBorder(boolean noTitle) {
        if (!noTitle) {
            this.setLineBorderOne(new LineBorder(this.getBorderColor(), 2));
            this.getLineBorderOne().setStyle(1);
            this.setBorder((Border)this.getLineBorderOne());
        }
        if (this.redelivery) {
            this.setLineBorderTwo(new OneSideTitleBorder());
            this.setBorder((Border)this.getLineBorderTwo());
        }
    }

    public void addContentFigure() {
        super.add((IFigure)this.contentFigure, null, -1);
    }

    public ScopeFigure(MessageFlowEntity scope) {
        super(scope);
    }

    protected Color getBorderColor() {
        return FigureColorRegistry.getDefault().get("container.border");
    }

    protected Color getExceptionStrategyTitleColor() {
        return FigureColorRegistry.getDefault().get("exception.strategy.color");
    }

    @Override
    protected String getDefaultTitleColorString() {
        return "container.title";
    }

    public void add(IFigure figure, Object constraint, int index) {
        this.contentFigure.add(figure, constraint, index);
    }

    public void remove(IFigure figure) {
        this.contentFigure.remove(figure);
    }

    @Override
    protected void severityChanged() {
        this.updateImageFigure();
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension minimumSize = super.getMinimumSize(wHint, hHint);
        if (this.rollback || this.isCoreRollback) {
            minimumSize.width = Math.max(minimumSize.width, 200);
        }
        return minimumSize;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension pref = super.getPreferredSize(wHint, hHint);
        if (this.redelivery || this.isCoreRollback) {
            pref.width = Math.max(pref.width, 200);
        }
        return new Dimension(Math.max(this.preferredEmptyWidth, pref.width), Math.max(this.preferredEmptyHeight, pref.height));
    }

    public void updateLabel() {
        String typeValue = "";
        String titleValue = "";
        this.typeLabel.setText(typeValue);
        this.getTitleLabel().setText(titleValue);
    }

    public void doUpdate() {
        this.updateLabel();
    }

    protected void addToSuper(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
    }

    protected void removeFromSuper(IFigure figure) {
        super.remove(figure);
    }

    @Override
    public boolean hasLabel() {
        return true;
    }

    @Override
    public void updateLabel(String value) {
        this.getTitleLabel().setText(value);
    }

    public synchronized Label getLabel() {
        return this.getTitleLabel();
    }

    @Override
    public String getLabelText() {
        return this.getTitleLabel().getText();
    }

    public boolean allowsDirectEditing() {
        return this.allowsDirectEditing;
    }

    public void setAllowsDirectEditing(boolean value) {
        this.allowsDirectEditing = value;
    }

    @Override
    public Color getTitleColor() {
        return FigureColorRegistry.getDefault().get("container.title");
    }

    @Override
    public void updateImageFigure() {
        super.updateImageFigure();
        this.disposeCreatedImages();
        this.getTitleFigure().removeAll();
        this.addOverlayIcon(this.getOverlay(FigureDecoratorPosition.TOP_LEFT), this.getTitleFigure());
        this.getTitleFigure().add((IFigure)this.typeLabel);
        this.getTitleFigure().add((IFigure)this.getTitleLabel());
        this.addOverlayIcon(this.getOverlay(FigureDecoratorPosition.TOP_RIGHT), this.getTitleFigure());
        this.updateLabel();
    }

    private void disposeCreatedImages() {
        for (Image image : this.createdImages) {
            if (image == null) continue;
            image.dispose();
        }
        this.createdImages.clear();
    }

    private void addOverlayIcon(OverlayIcon overlay, Figure parent) {
        if (overlay != null) {
            List<Tuple3<ImageDescriptor, MouseListener, Integer>> imageTuples = overlay.getAllImageTuples();
            for (Tuple3<ImageDescriptor, MouseListener, Integer> tuple : imageTuples) {
                ImageFigure newImageFigure = new ImageFigure();
                Image createdImage = ((ImageDescriptor)tuple.first()).createImage();
                newImageFigure.setImage(createdImage);
                this.createdImages.add(createdImage);
                if (tuple.second() != null) {
                    newImageFigure.addMouseListener((MouseListener)tuple.second());
                }
                parent.add((IFigure)newImageFigure);
            }
        }
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
        visitor.visitScope(this);
    }

    public Figure getTitleFigure() {
        return this.titleFigure;
    }

    protected void setTitleFigure(Figure titleFigure) {
        this.titleFigure = titleFigure;
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    protected void setTitleLabel(Label titleLabel) {
        this.titleLabel = titleLabel;
    }

    public LineBorder getLineBorderOne() {
        return this.lineBorderOne;
    }

    private void setLineBorderOne(LineBorder lineBorderOne) {
        this.lineBorderOne = lineBorderOne;
    }

    public LineBorder getLineBorderTwo() {
        return this.lineBorderTwo;
    }

    private void setLineBorderTwo(LineBorder lineBorderTwo) {
        this.lineBorderTwo = lineBorderTwo;
    }

    private final class OneSideTitleBorder
    extends LineBorder {
        private OneSideTitleBorder() {
        }

        public void paint(IFigure arg0, Graphics arg1, Insets arg2) {
            Rectangle paintRectangle = LineBorder.getPaintRectangle((IFigure)arg0, (Insets)arg2);
            arg1.setLineStyle(2);
            arg1.setForegroundColor(ScopeFigure.this.getBorderColor());
            arg1.setLineDash(new int[]{4, 4});
            arg1.setLineWidth(2);
            arg1.drawLine(paintRectangle.x, paintRectangle.y + 5, paintRectangle.x + paintRectangle.width, paintRectangle.y + 5);
            arg1.setForegroundColor(ColorConstants.black);
            TextLayout tl = new TextLayout((Device)Display.getCurrent());
            tl.setText(ScopeFigure.this.getTitleLabel().getText());
            TextStyle style = new TextStyle();
            style.background = Display.getCurrent().getSystemColor(1);
            tl.setStyle(style, 0, tl.getText().length());
            arg1.drawTextLayout(tl, paintRectangle.x + 5, paintRectangle.y - 3);
            tl.dispose();
        }

        public boolean isOpaque() {
            return false;
        }

        public Dimension getPreferredSize(IFigure f) {
            Dimension preferredSize = super.getPreferredSize(f);
            return preferredSize;
        }

        public Insets getInsets(IFigure figure) {
            Insets insets = super.getInsets(figure);
            insets.top += 4;
            return insets;
        }
    }
}

