/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.mule.tooling.messageflow.figure.CompartmentLaneLayout;
import org.mule.tooling.messageflow.layout.FlowDimensions;
import org.mule.tooling.messageflow.layout.FlowDimensionsCalculator;

public class RouteLaneLayout
extends CompartmentLaneLayout {
    protected static final int INTER_NODE_SPACING = 35;
    private int xOffset;

    @Override
    public void layout(IFigure nestedContainer) {
        List children = nestedContainer.getChildren();
        FlowDimensionsCalculator calculator = FlowDimensionsCalculator.getInstance();
        FlowDimensions dimensions = calculator.calculate(children);
        this.setFlowDimensions(dimensions);
        Map figureDimensions = children.stream().collect(Collectors.toMap(Function.identity(), IFigure::getPreferredSize));
        this.xOffset = 0;
        children.forEach(figure -> {
            int distanceToMiddleY = FlowDimensionsCalculator.calculateDistanceToMiddleY(figure);
            int yOffset = dimensions.getRequestMiddle() - distanceToMiddleY;
            Dimension figureDimension = (Dimension)figureDimensions.get(figure);
            Rectangle bounds = new Rectangle(this.xOffset, yOffset, figureDimension.width, figureDimension.height);
            this.setBoundsOfChild(nestedContainer, (IFigure)figure, bounds);
            this.xOffset += figureDimension.width;
            this.xOffset += 35;
        });
    }

    @Override
    protected int calculateWidth(IFigure container) {
        int width = super.calculateWidth(container);
        return width;
    }
}

