/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.mule.tooling.messageflow.figure.NodeFigure;
import org.mule.tooling.messageflow.figure.RequestResponseFigure;
import org.mule.tooling.messageflow.layout.FlowDimensionsCalculator;

public class RequestResponseLayout
extends AbstractLayout {
    private int requestResponseDistance = 0;

    public void layout(IFigure container) {
        Dimension size = container.getSize();
        Point offset = container.getClientArea().getLocation();
        if (size.width == 0 || size.height == 0) {
            return;
        }
        RequestResponseFigure reqresp = (RequestResponseFigure)container;
        Dimension reqSize = reqresp.getRequestFigure().getPreferredSize();
        int reqx = size.width / 2 - reqSize.width / 2;
        Rectangle reqBounds = new Rectangle(reqx, 0, reqSize.width, reqSize.height);
        reqBounds.translate(offset);
        reqresp.getRequestFigure().setBounds(reqBounds);
        Dimension respSize = reqresp.getResponseFigure().getPreferredSize();
        int respx = size.width / 2 - respSize.width / 2;
        int respy = size.height - respSize.height;
        Rectangle respBounds = new Rectangle(respx, respy, respSize.width, respSize.height);
        respBounds.translate(offset);
        reqresp.getResponseFigure().setBounds(respBounds);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        RequestResponseFigure reqresp = (RequestResponseFigure)container;
        NodeFigure requestFigure = reqresp.getRequestFigure();
        int requestMiddle = FlowDimensionsCalculator.calculateDistanceToMiddleY((IFigure)requestFigure);
        IFigure responseFigure = reqresp.getResponseFigure();
        int responseMiddle = FlowDimensionsCalculator.calculateDistanceToMiddleY(responseFigure);
        int totHeight = requestMiddle + this.getRequestResponseDistance() + responseMiddle;
        int totWidth = Math.max(requestFigure.getPreferredSize().width, responseFigure.getPreferredSize().width);
        return new Dimension(totWidth, totHeight);
    }

    public int getRequestResponseDistance() {
        return this.requestResponseDistance;
    }

    public void setRequestResponseDistance(int requestResponseDistance) {
        this.requestResponseDistance = requestResponseDistance;
        this.invalidate();
    }
}

