/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.icons.ImageUtils;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.FigureImageRegistry;
import org.mule.tooling.messageflow.figure.NodeFigure;
import org.mule.tooling.messageflow.figure.RequestResponseLayout;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.module.NodeDefinition;

public class RequestResponseFigure
extends EntityFigure<MessageFlowEntity> {
    private NodeFigure requestFigure;
    private ImageFigure responseFigure;
    private RequestResponseLayout layout = new RequestResponseLayout();

    public RequestResponseFigure(MessageFlowEntity entity, NodeFigure nodeFigure) {
        super(entity);
        this.setLayoutManager((LayoutManager)this.layout);
        this.requestFigure = nodeFigure;
        this.add((IFigure)this.requestFigure);
        NodeDefinition node = ((MessageFlowNode)nodeFigure.getEntity()).getDefinition();
        Image image = node.getCanvasImage();
        Supplier<Image> imageProvider = () -> new Image((Device)Display.getCurrent(), ImageUtils.convertToGray((ImageData)image.getImageData()));
        Image grayImage = FigureImageRegistry.getDefault().getImage("gray-" + node.getId(), imageProvider);
        this.responseFigure = new ImageFigure(grayImage);
        this.responseFigure.setBorder((Border)new MarginBorder(2));
        this.add((IFigure)this.responseFigure);
        this.applyStyle();
    }

    public NodeFigure getRequestFigure() {
        return this.requestFigure;
    }

    public IFigure getResponseFigure() {
        return this.responseFigure;
    }

    public void setRequestResponseDistance(int distance) {
        this.layout.setRequestResponseDistance(distance);
    }

    @Override
    public void setSeverity(int severity) {
        super.setSeverity(severity);
        this.requestFigure.setSeverity(severity);
    }

    @Override
    protected void severityChanged() {
    }

    @Override
    public boolean hasLabel() {
        return true;
    }

    @Override
    public void updateLabel(String value) {
        this.requestFigure.setLabelText(value);
    }

    @Override
    public synchronized Figure getLabel() {
        return this.requestFigure.getLabel();
    }

    @Override
    public String getLabelText() {
        return this.requestFigure.getLabelText();
    }

    @Override
    public void updateImageFigure() {
        super.updateImageFigure();
        this.requestFigure.updateImageFigure();
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
        visitor.visitRequestResponse(this);
    }

    @Override
    public void setErrors(List<MessageFlowEntityError> errors) {
        this.requestFigure.setErrors(errors);
    }
}

