/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.mule.tooling.messageflow.figure.ContainerFigure;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;

public class OnErrorContainerFigure
extends ContainerFigure {
    private static final String ATTR_WHEN = "when";
    private static final String ATTR_TYPE = "type";
    private static final int MAX_VALUE_LENGTH = 30;

    public OnErrorContainerFigure(Container container, boolean allowEdit) {
        super(container, allowEdit);
        this.allowsDirectEditing = allowEdit;
    }

    @Override
    public void updateLabel() {
        super.updateLabel();
        Container containerNode = (Container)this.getEntity();
        StringBuilder title = new StringBuilder(containerNode.getName());
        containerNode.getProperties().getProperties().forEach(property -> this.addProperty((IReadOnlyProperty)property, title));
        this.getTitleLabel().setText(title.toString());
    }

    @Override
    public Label getLabel() {
        Label result = super.getLabel();
        result.setText(((Container)this.getEntity()).getName());
        return result;
    }

    private void addProperty(IReadOnlyProperty property, StringBuilder title) {
        String propertyName = property.getName();
        Object propertyValue = property.getValue();
        if ((propertyName.equals(ATTR_TYPE) || propertyName.equals(ATTR_WHEN)) && propertyValue != null && !((String)propertyValue).equals("")) {
            title.append(System.lineSeparator());
            title.append(propertyName);
            title.append(": ");
            if (((String)propertyValue).length() > 30) {
                propertyValue = ((String)propertyValue).substring(0, 30) + "...";
            }
            title.append((String)propertyValue);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        int countAttrs = this.countAttrs((Container)this.getEntity());
        if (countAttrs > 0) {
            this.drawSeparationLine(graphics);
        }
    }

    private void drawSeparationLine(Graphics graphics) {
        graphics.setLineStyle(6);
        graphics.setLineDash(new float[]{3.0f, 2.0f});
        graphics.setLineDashOffset(20.0f);
        graphics.setForegroundColor(this.getStyleableBorderColor());
        int x = this.getTitleLabel().getLocation().x;
        int y = this.getTitleFigure().getLocation().y + 15;
        Point left = new Point(x, y);
        Point right = new Point(x + this.getBounds().width, y);
        graphics.drawLine(left, right);
    }

    private int countAttrs(Container entity) {
        int i = 0;
        Container containerNode = (Container)this.getEntity();
        List properties = containerNode.getProperties().getProperties();
        for (IReadOnlyProperty property : properties) {
            String propertyName = property.getName();
            String propertyValue = property.getValue();
            if (!propertyName.equals(ATTR_TYPE) && !propertyName.equals(ATTR_WHEN) || propertyValue == null || propertyValue.equals("")) continue;
            ++i;
        }
        return i;
    }
}

