/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.ParagraphTextFlowLabel;
import org.mule.tooling.messageflow.figure.TextFlowLabel;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorPosition;
import org.mule.tooling.messageflow.figuredecorator.OverlayIcon;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public abstract class NodeFigure
extends EntityFigure<MessageFlowNode> {
    private final String imageId;
    private ImageFigure imageFigure;
    private Image decorated;
    private TextFlowLabel label;
    private Label descriptionLabel;
    private boolean isDeprecated;
    private MessageFlowNode node;
    private boolean active;

    public NodeFigure(MessageFlowNode node, String imageId) {
        super(node);
        this.node = node;
        this.imageId = imageId;
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        layout.setSpacing(2);
        this.setLayoutManager((LayoutManager)layout);
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        this.isDeprecated = CoreUtils.isDeprecated((MessageFlowNode)node, (IMuleProject)muleProject);
        this.imageFigure = new ImageFigure();
        this.add((IFigure)this.imageFigure);
        this.updateImageFigure();
        this.label = new ParagraphTextFlowLabel();
        this.createDescriptionLabel();
        this.updateName();
        this.add((IFigure)this.label);
        this.setBorder((Border)new MarginBorder(2));
        this.setToolTip((IFigure)new Label(node.getDescription()));
        this.applyStyle();
        this.active = true;
    }

    private void createDescriptionLabel() {
        this.descriptionLabel = new Label();
        Font font = this.label.getFont();
        this.descriptionLabel.setFont(font);
        this.descriptionLabel.setForegroundColor(ThemeUtils.getCurrentTheme().getDescriptionForegroundColor());
        this.updateDescriptionLabel();
    }

    private void updateDescriptionLabel() {
        NodeDefinition definition = this.node.getDefinition();
        if (definition != null) {
            String name = definition.getName();
            if (!name.equals(this.node.getName())) {
                this.add((IFigure)this.descriptionLabel, 1);
                this.descriptionLabel.setText(name);
            } else if (this.descriptionLabel.getParent() == this) {
                this.remove((IFigure)this.descriptionLabel);
            }
        }
    }

    public IFigure getToolTip() {
        String description = this.node.getDescription();
        return StringUtils.isNotBlank((String)description) ? new ParagraphTextFlowLabel(description) : null;
    }

    @Override
    public void updateImageFigure() {
        this.updateImageFigure((MessageFlowEntity)this.getEntity());
    }

    public void updateImageFigure(MessageFlowEntity entity) {
        super.updateImageFigure();
        Image image = this.node.getDefinition().getCanvasImage();
        if (image == null) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_SYNCED");
        }
        if (this.imageFigure == null) {
            MuleCorePlugin.logWarning((String)"imageFigure was null (NodeFigure#updateImageFigure)");
        } else {
            this.imageFigure.setImage(image);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            if (this.decorated != null && !this.decorated.isDisposed()) {
                System.out.println("Solved potential leak. Cleaning up image -> " + this.imageId);
                this.decorated.dispose();
                this.decorated = null;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected ImageDescriptor getImageDescriptor(OverlayIcon overlayIcon) {
        if (overlayIcon == null) {
            return null;
        }
        return overlayIcon.getImageDescriptor();
    }

    @Override
    protected void severityChanged() {
        this.updateImageFigure();
    }

    public void updateName() {
        Object name = ((MessageFlowNode)this.getEntity()).getName();
        if (this.isDeprecated && !((String)name).endsWith(" (Deprecated)")) {
            name = (String)name + " (Deprecated)";
        }
        this.label.setText((String)name);
        this.updateDescriptionLabel();
    }

    public void updateDescription() {
        this.setToolTip((IFigure)new ParagraphTextFlowLabel(((MessageFlowNode)this.getEntity()).getDescription()));
    }

    @Override
    public boolean hasLabel() {
        return true;
    }

    @Override
    public void updateLabel(String value) {
        this.label.setText(value);
    }

    @Override
    public synchronized String getLabelText() {
        return this.label.getText();
    }

    @Override
    public Figure getLabel() {
        return this.label;
    }

    @Override
    public void setLabelText(String value) {
        this.label.setText(value);
    }

    public void deactivate() {
        if (this.decorated != null && !this.decorated.isDisposed()) {
            this.active = false;
            this.decorated.dispose();
            this.decorated = null;
        }
        this.imageFigure = null;
    }

    public boolean isActive() {
        return this.active;
    }

    public ImageFigure getImageFigure() {
        return this.imageFigure;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.decorated != null) {
            this.decorated.dispose();
        }
        this.paintSeverity(graphics);
        this.paintBottomLeft(graphics);
        this.paintTopLeft(graphics);
        this.paintTopRight(graphics);
        this.paintBottomRight(graphics);
    }

    private void paintBottomRight(Graphics graphics) {
        ImageDescriptor bottomRight = this.getImageDescriptor(this.getOverlay(FigureDecoratorPosition.BOTTOM_RIGHT));
        this.paintDecorator(graphics, bottomRight);
    }

    private void paintTopRight(Graphics graphics) {
        ImageDescriptor topRight = this.getImageDescriptor(this.getOverlay(FigureDecoratorPosition.TOP_RIGHT));
        this.paintDecorator(graphics, topRight);
    }

    private void paintTopLeft(Graphics graphics) {
        ImageDescriptor topLeft = this.getImageDescriptor(this.getOverlay(FigureDecoratorPosition.TOP_LEFT));
        this.paintDecorator(graphics, topLeft);
    }

    private void paintBottomLeft(Graphics graphics) {
        ImageDescriptor bottomLeft = this.getImageDescriptor(this.getOverlay(FigureDecoratorPosition.BOTTOM_LEFT));
        this.paintDecorator(graphics, bottomLeft);
    }

    private void paintSeverity(Graphics graphics) {
        ImageDescriptor severityDecorator = this.getDecorationImageDescriptor();
        this.paintDecorator(graphics, severityDecorator);
    }

    @Override
    protected Figure getFigureWithError() {
        return this.imageFigure;
    }

    private void paintDecorator(Graphics graphics, ImageDescriptor decorator) {
        if (decorator != null) {
            Image decoratorImage = decorator.createImage();
            graphics.drawImage(decoratorImage, this.imageFigure.getBounds().x, this.imageFigure.getBounds().y);
            decoratorImage.dispose();
        }
    }
}

