/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import com.google.common.base.Optional;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.NestedContainerLayout;
import org.mule.tooling.messageflow.figure.ParagraphTextFlowLabel;
import org.mule.tooling.messageflow.figure.TextFlowLabel;
import org.mule.tooling.messageflow.layout.ContainerLayoutFactory;
import org.mule.tooling.messageflow.layout.ContainerLayoutFactoryManager;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.module.NestedContainerDefinition;

public class NestedContainerFigure
extends EntityFigure<NestedContainer> {
    protected int preferredEmptyWidth = 80;
    protected int preferredEmptyHeight = 50;
    private Figure contentFigure;
    private TextFlowLabel titleLabel;
    private IFigure titleFigure;
    private Label prompt;
    private NestedContainerDefinition definition;
    protected EditPart parentEditPart;

    public NestedContainerFigure(NestedContainer nestedContainer, boolean allowEdit) {
        this(nestedContainer, allowEdit, null);
    }

    public NestedContainerFigure(NestedContainer nestedContainer, boolean allowEdit, EditPart parentEditPart) {
        super(nestedContainer);
        this.parentEditPart = parentEditPart;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.setLayoutManager((LayoutManager)layout);
        boolean shouldAddHeader = this.shouldDisplayTitleHeader();
        if (shouldAddHeader) {
            Figure header = this.createTitleFigure(nestedContainer, layout);
            this.setTitleFigure((IFigure)header);
            this.addToSuper((IFigure)header);
        }
        this.definition = (NestedContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition(((NestedContainer)this.getEntity()).getType());
        Figure newContentFigure = this.createContentFigure(nestedContainer, shouldAddHeader);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
        this.setContentFigure(newContentFigure);
        this.addToSuper((IFigure)this.getContentFigure(), gridData);
        this.updateImageFigure();
        this.applyStyle();
    }

    public boolean shouldDisplayTitleHeader() {
        return StringUtils.isNotEmpty((String)this.getDisplayName());
    }

    public String getDisplayName() {
        return ((NestedContainer)this.getEntity()).getName();
    }

    protected Figure createContentFigure(NestedContainer nestedContainer, boolean shouldAddHeader) {
        ContentFigure newContentFigure = new ContentFigure();
        Optional<ContainerLayoutFactory> layoutFactory = this.getLayoutFactory();
        NestedContainerLayout layoutManager = layoutFactory.isPresent() ? ((ContainerLayoutFactory)layoutFactory.get()).create() : new NestedContainerLayout();
        newContentFigure.setLayoutManager((LayoutManager)layoutManager);
        this.prompt = this.createPrompt(this.definition.getPrompt());
        newContentFigure.add((IFigure)this.prompt);
        MarginBorder margin = new MarginBorder(shouldAddHeader ? 5 : 0, 15, 0, 15);
        newContentFigure.setBorder((Border)margin);
        return newContentFigure;
    }

    private Optional<ContainerLayoutFactory> getLayoutFactory() {
        return ContainerLayoutFactoryManager.instance().getLayoutFactory(this.definition.getLayoutFactoryId());
    }

    protected void addToSuper(IFigure figure) {
        super.add(figure, null, -1);
    }

    protected void addToSuper(IFigure figure, Object constraint) {
        super.add(figure, constraint, -1);
    }

    protected boolean isEmpty() {
        return ((NestedContainer)this.getEntity()).getCompartmentLaneEntries().isEmpty();
    }

    protected Figure createTitleFigure(NestedContainer nestedContainer, GridLayout parentLayout) {
        Figure newTitleFigure = new Figure();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMajorAlignment(0);
        newTitleFigure.setLayoutManager((LayoutManager)flowLayout);
        this.titleLabel = this.createTitleLabel(nestedContainer);
        newTitleFigure.add((IFigure)this.titleLabel);
        GridData gridData = new GridData(0x1000000, 128, true, false);
        parentLayout.setConstraint((IFigure)newTitleFigure, (Object)gridData);
        return newTitleFigure;
    }

    protected TextFlowLabel createTitleLabel(NestedContainer nestedContainer) {
        ParagraphTextFlowLabel newTitleLabel = new ParagraphTextFlowLabel();
        newTitleLabel.setOpaque(false);
        newTitleLabel.setForegroundColor(ColorConstants.gray);
        newTitleLabel.setText(this.getDisplayName());
        return newTitleLabel;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.repaint();
    }

    public Figure getContentFigure() {
        return this.contentFigure;
    }

    public void add(IFigure figure, Object constraint, int index) {
        this.getContentFigure().add(figure, constraint, index);
        this.hidePrompt();
    }

    public void remove(IFigure figure) {
        this.getContentFigure().remove(figure);
        this.showPrompt();
    }

    @Override
    protected void severityChanged() {
        this.updateImageFigure();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension pref = super.getPreferredSize(wHint, hHint);
        return new Dimension(Math.max(this.preferredEmptyWidth, pref.width), Math.max(this.preferredEmptyHeight, pref.height));
    }

    protected void addToSuper(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
    }

    @Override
    public boolean hasLabel() {
        return false;
    }

    public void setContentFigure(Figure contentFigure) {
        this.contentFigure = contentFigure;
    }

    public IFigure getTitleFigure() {
        return this.titleFigure;
    }

    public void setTitleFigure(IFigure titleFigure) {
        this.titleFigure = titleFigure;
    }

    public TextFlowLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(TextFlowLabel titleLabel) {
        this.titleLabel = titleLabel;
    }

    public void setPrompt(String prompt) {
        this.prompt.setText(prompt);
    }

    private Label createPrompt(String promptText) {
        Label label = new Label();
        label.setText(promptText);
        label.setOpaque(false);
        label.setLabelAlignment(2);
        label.setForegroundColor(ColorConstants.lightGray);
        return label;
    }

    private void hidePrompt() {
        if (this.getContentFigure().getChildren().contains(this.prompt)) {
            this.getContentFigure().remove((IFigure)this.prompt);
            ArrayList<IFigure> figures = new ArrayList<IFigure>(1);
            figures.add((IFigure)this.prompt);
            MessageFlowUtils.fireDisposedIFigureEvent(figures);
        }
    }

    private void showPrompt() {
        if (this.getContentFigure().getChildren().isEmpty()) {
            this.getContentFigure().add((IFigure)this.prompt);
        }
        this.prompt.setVisible(true);
    }

    public int getRowNumber() {
        return this.getDefinition().getRowNumber();
    }

    public NestedContainerDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
        visitor.visitNestedContainer(this);
    }

    public void invalidate() {
        if (this.isValid()) {
            super.invalidate();
        }
    }

    private static final class ContentFigure
    extends Figure {
        private ContentFigure() {
        }

        public String toString() {
            return "contentFigure";
        }
    }
}

