/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.SimpleTextFlowLabel;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageToUserNode;

public class MessageToUserFigure
extends EntityFigure<MessageFlowEntity> {
    private static Font messageFont;

    public MessageToUserFigure(MessageToUserNode messageToUser) {
        super(messageToUser);
        FlowLayout layout = new FlowLayout(true);
        this.setLayoutManager((LayoutManager)layout);
        SimpleTextFlowLabel label = new SimpleTextFlowLabel(messageToUser.getText());
        label.setFont(MessageToUserFigure.getCustomFont());
        label.setBackgroundColor(ColorConstants.white);
        label.setForegroundColor(ColorConstants.lightGray);
        this.add((IFigure)label);
        this.applyStyle();
    }

    private static Font getCustomFont() {
        if (messageFont == null) {
            Display display = Display.getCurrent();
            FontRegistry fontRegistry = new FontRegistry(display);
            FontData[] fontData = display.getSystemFont().getFontData();
            fontData[0].setHeight(14);
            fontRegistry.put("canvas-message-font", fontData);
            messageFont = fontRegistry.get("canvas-message-font");
        }
        return messageFont;
    }

    @Override
    protected void severityChanged() {
    }

    @Override
    public boolean hasLabel() {
        return false;
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
        visitor.visitMessageToUser(this);
    }
}

