/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class GreedyFlowLayout
extends FlowLayout {
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFTTOP = 1;
    public static final int ALIGN_RIGHTBOTTOM = 2;
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;
    protected boolean horizontal = true;
    protected boolean fill = false;
    protected Transposer transposer = new Transposer();
    protected int majorAlignment;
    protected int minorAlignment;
    protected int minorSpacing;
    protected int majorSpacing;
    protected WorkingData data;

    public GreedyFlowLayout() {
        this.transposer.setEnabled(!this.horizontal);
        this.majorAlignment = 1;
        this.minorAlignment = 1;
        this.minorSpacing = 5;
        this.majorSpacing = 5;
        this.data = null;
    }

    public GreedyFlowLayout(boolean isHorizontal) {
        this.transposer.setEnabled(!this.horizontal);
        this.majorAlignment = 1;
        this.minorAlignment = 1;
        this.minorSpacing = 5;
        this.majorSpacing = 5;
        this.data = null;
        this.setHorizontal(isHorizontal);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int maxWidth;
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        if (this.isHorizontal()) {
            maxWidth = wHint;
            hHint = -1;
        } else {
            maxWidth = hHint;
            wHint = -1;
        }
        if (maxWidth < 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        Dimension prefSize = new Dimension();
        List children = container.getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(this.getChildSize(child, wHint, hHint));
            if (i == 0) {
                width = childSize.width;
                height = childSize.height;
            } else if (width + childSize.width + this.getMinorSpacing() > maxWidth) {
                prefSize.height += height + this.getMajorSpacing();
                prefSize.width = Math.max(prefSize.width, width);
                width = childSize.width;
                height = childSize.height;
            } else {
                width += childSize.width + this.getMinorSpacing();
                height = Math.max(height, childSize.height);
            }
            ++i;
        }
        prefSize.height += height;
        prefSize.width = Math.max(prefSize.width, width);
        prefSize = this.transposer.t(prefSize);
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        return child.getPreferredSize(wHint, hHint);
    }

    public int getMajorAlignment() {
        return this.majorAlignment;
    }

    public int getMajorSpacing() {
        return this.majorSpacing;
    }

    public int getMinorAlignment() {
        return this.minorAlignment;
    }

    public int getMinorSpacing() {
        return this.minorSpacing;
    }

    protected void initRow() {
        this.data.rowX = 0;
        this.data.rowHeight = 0;
        this.data.rowWidth = 0;
        this.data.rowCount = 0;
    }

    protected void initVariables(IFigure parent) {
        this.data.row = new IFigure[parent.getChildren().size()];
        this.data.bounds = new Rectangle[this.data.row.length];
        this.data.maxWidth = this.data.area.width;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    protected boolean isSensitiveHorizontally(IFigure parent) {
        return this.isHorizontal();
    }

    protected boolean isSensitiveVertically(IFigure parent) {
        return !this.isHorizontal();
    }

    public void layout(IFigure parent) {
        Dimension psize = this.calculatePreferredSize(parent, -1, -1);
        Insets pinset = parent.getInsets();
        psize.width -= pinset.left + pinset.right;
        psize.height -= pinset.top + pinset.bottom;
        this.data = new WorkingData();
        Rectangle relativeArea = parent.getClientArea();
        this.data.area = this.transposer.t(relativeArea);
        Iterator iterator = parent.getChildren().iterator();
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            wHint = parent.getClientArea().width;
            hHint = psize.height;
        } else {
            hHint = parent.getClientArea().height;
            wHint = psize.width;
        }
        this.initVariables(parent);
        this.initRow();
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
            Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
            if (this.data.rowCount > 0 && this.data.rowWidth + pref.width > this.data.maxWidth) {
                this.layoutRow(parent);
            }
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.getMinorSpacing();
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = Math.max(this.data.rowHeight, r.height);
            this.data.row[this.data.rowCount] = f;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
        }
        if (this.data.rowCount != 0) {
            this.layoutRow(parent);
        }
        this.data = null;
    }

    protected void layoutRow(IFigure parent) {
        int majorAdjustment = 0;
        int minorAdjustment = 0;
        int correctMajorAlignment = this.majorAlignment;
        int correctMinorAlignment = this.minorAlignment;
        majorAdjustment = this.data.area.width - this.data.rowWidth + this.getMinorSpacing();
        switch (correctMajorAlignment) {
            case 1: {
                majorAdjustment = 0;
                break;
            }
            case 0: {
                majorAdjustment /= 2;
                break;
            }
        }
        int j = 0;
        while (j < this.data.rowCount) {
            if (this.fill) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                minorAdjustment = this.data.rowHeight - this.data.bounds[j].height;
                switch (correctMinorAlignment) {
                    case 1: {
                        minorAdjustment = 0;
                        break;
                    }
                    case 0: {
                        minorAdjustment /= 2;
                        break;
                    }
                }
                this.data.bounds[j].y += minorAdjustment;
            }
            this.data.bounds[j].x += majorAdjustment;
            this.setBoundsOfChild(parent, this.data.row[j], this.transposer.t(this.data.bounds[j]));
            ++j;
        }
        this.data.rowY += this.getMajorSpacing() + this.data.rowHeight;
        this.initRow();
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    public void setStretchMinorAxis(boolean value) {
        this.fill = value;
    }

    public void setHorizontal(boolean flag) {
        if (this.horizontal == flag) {
            return;
        }
        this.invalidate();
        this.horizontal = flag;
        if (this.transposer != null) {
            this.transposer.setEnabled(!this.horizontal);
        }
    }

    public void setMajorAlignment(int align) {
        this.majorAlignment = align;
    }

    public void setMajorSpacing(int n) {
        this.majorSpacing = n;
    }

    public void setMinorAlignment(int align) {
        this.minorAlignment = align;
    }

    public void setMinorSpacing(int n) {
        this.minorSpacing = n;
    }

    protected class WorkingData {
        public int rowHeight;
        public int rowWidth;
        public int rowCount;
        public int rowX;
        public int rowY;
        public int maxWidth;
        public Rectangle[] bounds;
        public Rectangle area;
        public IFigure[] row;

        protected WorkingData() {
        }
    }
}

