/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.function.Supplier;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class FigureImageRegistry {
    private static FigureImageRegistry defaultInstance;
    private ImageRegistry imageRegistry;

    public FigureImageRegistry() {
        this.imageRegistry = new ImageRegistry();
    }

    public FigureImageRegistry(Display display) {
        this.imageRegistry = new ImageRegistry(display);
    }

    private void registerDefaults() {
    }

    public void register(String id, ImageDescriptor color) {
        this.imageRegistry.put(id, color);
    }

    public void register(String id, Image image) {
        this.imageRegistry.put(id, image);
    }

    public Image get(String id) {
        return this.imageRegistry.get(id);
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.imageRegistry.getDescriptor(id);
    }

    public Image getImage(String id, Supplier<Image> imageProvider) {
        Image image = this.imageRegistry.get(id);
        if (image == null) {
            image = imageProvider.get();
            this.register(id, image);
        }
        return image;
    }

    public Image get(String id, ImageDescriptor desc) {
        Image image = this.get(id);
        if (image == null) {
            this.register(id, desc);
        }
        return this.get(id);
    }

    public static FigureImageRegistry getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new FigureImageRegistry();
            defaultInstance.registerDefaults();
        }
        return defaultInstance;
    }

    public void flushRegistry() {
        this.imageRegistry.dispose();
    }

    public static void flushDefault() {
        if (defaultInstance != null) {
            defaultInstance.flushRegistry();
            defaultInstance = new FigureImageRegistry();
            defaultInstance.registerDefaults();
        }
    }

    public static void setDefaultInstance(FigureImageRegistry defaultInstance) {
        FigureImageRegistry.defaultInstance = defaultInstance;
    }
}

