/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.messageflow.Activator;
import org.osgi.framework.Bundle;

public class FigureFontRegistry {
    private static final String FONTS_OPEN_SANS_OPEN_SANS_REGULAR_TTF = "resources/Fonts/Open_Sans/OpenSans-Regular.ttf";
    private static FigureFontRegistry defaultInstance;
    private FontRegistry fontRegistry;
    public static final String FLOWS_TITLE = "flows.title";
    public static final String FLOWS_TITLE2 = "flows.title2";

    public FigureFontRegistry() {
        this.fontRegistry = new FontRegistry();
    }

    public FigureFontRegistry(Display display) {
        this.fontRegistry = new FontRegistry(display);
    }

    private void registerDefaults() {
        Bundle bundle = Activator.getDefault().getBundle();
        Path path = new Path(FONTS_OPEN_SANS_OPEN_SANS_REGULAR_TTF);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, Collections.emptyMap());
        URL fileUrl = null;
        try {
            fileUrl = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(fileUrl.getPath());
        Display.getCurrent().loadFont(file.toString());
        this.fontRegistry.put(FLOWS_TITLE, new FontData[]{new FontData("Open Sans", 12, 0)});
    }

    public void register(String id, Font font) {
        this.fontRegistry.put(id, font.getFontData());
    }

    public Font get(String id) {
        return this.fontRegistry.get(id);
    }

    public static FigureFontRegistry getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new FigureFontRegistry();
            defaultInstance.registerDefaults();
        }
        return defaultInstance;
    }

    public static void setDefaultInstance(FigureFontRegistry defaultInstance) {
        FigureFontRegistry.defaultInstance = defaultInstance;
    }
}

