/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class FigureColorRegistry {
    public static final String PALETTE_ITEM_SELECTION_COLOR = "selection.color";
    public static final String RESPONSE_FOREGROUND = "response.foreground";
    public static final String MULTISOURCE_TITLE = "multisource.title";
    public static final String MULTISOURCE_BORDER = "multisource.border";
    public static final String SUBFLOW_TITLE = "subflow.title";
    public static final String TRANSACTION_DEMARCATION = "transaction.demarcation.color";
    public static final String EXCEPTION_STRATEGY = "exception.strategy.color";
    public static final String FLOWS_TITLE = "flows.title";
    public static final String FLOWS_BORDER = "flows.border";
    public static final String CONTAINER_BORDER = "container.border";
    public static final String CONTAINER_TITLE = "container.title";
    public static final String SPLITTER_PATTERN_BORDER = "splitter.pattern.border";
    public static final String SPLITTER_BORDER = "splitter.border";
    public static final String SPLITTER_PATTERN_BACKGROUND = "splitter.pattern.background";
    public static final String SELECTION_BORDER = "selection.border";
    public static final String CUSTOM_COLOR = "custom.color";
    public static final String CUSTOM_COLOR2 = "custom.color2";
    public static final String CONTAINER_FONT_COLOR = "container.font.color";
    public static final String CONNECTOR_DEFAULT_FIGURE = "connector.figure";
    public static final String SELECTION_BACKGROUND = "selection.background";
    public static final String DEFAULT_LANE_COLOR = "default.lane.color";
    private static FigureColorRegistry defaultInstance;
    private ColorRegistry colorRegistry;

    public FigureColorRegistry() {
        this.colorRegistry = new ColorRegistry();
    }

    public FigureColorRegistry(Display display) {
        this.colorRegistry = new ColorRegistry(display);
    }

    private void registerDefaults() {
        this.register(PALETTE_ITEM_SELECTION_COLOR, new RGB(105, 184, 224));
        this.register(CONTAINER_BORDER, new RGB(224, 224, 224));
        this.register(DEFAULT_LANE_COLOR, new RGB(230, 230, 230));
        this.register(CONTAINER_TITLE, new RGB(137, 157, 102));
        this.register(CUSTOM_COLOR, new RGB(58, 58, 58));
        this.register(CUSTOM_COLOR2, new RGB(255, 0, 0));
        this.register(FLOWS_BORDER, new RGB(224, 224, 224));
        this.register(FLOWS_TITLE, new RGB(168, 206, 226));
        this.register(EXCEPTION_STRATEGY, new RGB(252, 158, 112));
        this.register(TRANSACTION_DEMARCATION, new RGB(71, 139, 28));
        this.register(SUBFLOW_TITLE, new RGB(224, 224, 224));
        this.register(MULTISOURCE_BORDER, new RGB(96, 128, 192));
        this.register(MULTISOURCE_TITLE, new RGB(140, 192, 224));
        this.register(SPLITTER_PATTERN_BORDER, new RGB(128, 128, 128));
        this.register(SPLITTER_PATTERN_BACKGROUND, new RGB(244, 245, 247));
        this.register(SPLITTER_BORDER, new RGB(192, 192, 192));
        this.register(RESPONSE_FOREGROUND, new RGB(109, 109, 109));
        this.register(SELECTION_BORDER, new RGB(179, 179, 179));
        this.register(CONTAINER_FONT_COLOR, new RGB(0, 0, 0));
        this.register(CONNECTOR_DEFAULT_FIGURE, new RGB(152, 154, 155));
        this.register(SELECTION_BACKGROUND, new RGB(240, 240, 255));
    }

    public void register(String id, RGB color) {
        this.colorRegistry.put(id, color);
    }

    public Color get(String id) {
        return this.colorRegistry.get(id);
    }

    public static FigureColorRegistry getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new FigureColorRegistry();
            defaultInstance.registerDefaults();
        }
        return defaultInstance;
    }

    public static void setDefaultInstance(FigureColorRegistry defaultInstance) {
        FigureColorRegistry.defaultInstance = defaultInstance;
    }
}

