/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.images.StudioImages;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorFactoryManager;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorPosition;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecorator;
import org.mule.tooling.messageflow.figuredecorator.OverlayIcon;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public abstract class EntityFigure<T extends MessageFlowEntity>
extends Figure {
    protected static final int MAX_DISTANCE_ERROR_TOOLTIP = 20;
    private static final String DELIMITER = "\n";
    protected int severity;
    private T entity;
    private IFigureDecorator figureDecorator;
    private List<MessageFlowEntityError> errors;

    public EntityFigure(T entity) {
        this.entity = entity;
        this.addMouseMotionListener(this.getErrorTooltipMouseMotionListener());
        this.errors = new ArrayList<MessageFlowEntityError>();
    }

    public T getEntity() {
        return this.entity;
    }

    public void setSeverity(int severity) {
        if (this.severity != severity) {
            this.severity = severity;
            this.severityChanged();
        }
    }

    public int getSeverity() {
        return this.severity;
    }

    protected void applyStyle() {
        ThemeUtils.applyStylingTo((IFigure)this);
    }

    protected abstract void severityChanged();

    public void updateImageFigure() {
        this.figureDecorator = FigureDecoratorFactoryManager.getDefault().createDecorator((MessageFlowEntity)this.getEntity());
    }

    public void updateChildren(List<?> childrenFigure) {
        for (Object child : childrenFigure) {
            if (child instanceof EntityFigure) {
                ((EntityFigure)((Object)child)).updateImageFigure();
                continue;
            }
            if (!(child instanceof IFigure)) continue;
            this.updateChildren(((IFigure)child).getChildren());
        }
    }

    protected OverlayIcon getOverlay(FigureDecoratorPosition pos) {
        return this.getFigureDecorator().getOverlay(pos);
    }

    protected List<OverlayIcon> getOverlayList(FigureDecoratorPosition pos) {
        return this.getFigureDecorator().getOverlayList(pos);
    }

    protected IFigureDecorator getFigureDecorator() {
        return this.figureDecorator;
    }

    protected void setFigureDecorator(IFigureDecorator decorator) {
        this.figureDecorator = decorator;
    }

    protected ImageDescriptor getDecorationImageDescriptor() {
        if (this.getSeverity() == 2) {
            return StudioImages.OVR_COMPONENT_ERROR;
        }
        if (this.getSeverity() == 1) {
            return StudioImages.OVR_COMPONENT_WARNING;
        }
        return null;
    }

    public abstract boolean hasLabel();

    public void updateLabel(String value) {
    }

    protected String getDefaultTitleColorString() {
        return null;
    }

    protected Color getTitleColor() {
        RGB parsedRGB;
        String id;
        String titleColorRGB;
        NodeDefinition definition;
        FigureColorRegistry colorRegistry = FigureColorRegistry.getDefault();
        Color titleColor = colorRegistry.get(this.getDefaultTitleColorString());
        if (this.getEntity() instanceof MessageFlowNode && (definition = ((MessageFlowNode)this.getEntity()).getDefinition()) != null && !StringUtils.isEmpty((String)(titleColorRGB = definition.getTitleColor())) && (titleColor = colorRegistry.get(id = definition.getId())) == null && (parsedRGB = UiUtils.parseRGBString((String)titleColorRGB)) != null) {
            colorRegistry.register(id, parsedRGB);
            titleColor = colorRegistry.get(id);
        }
        return titleColor;
    }

    public Figure getLabel() {
        return null;
    }

    public String getLabelText() {
        return null;
    }

    public void setLabelText(String value) {
    }

    public abstract void accept(EntityFigureVisitor var1);

    public void setErrors(List<MessageFlowEntityError> errors) {
        this.errors = errors;
    }

    private Label getErrorLabel() {
        if (this.errors.isEmpty()) {
            return null;
        }
        String errorMessage = this.errors.stream().map(e -> e.getMessage()).collect(Collectors.joining(DELIMITER));
        return new Label(errorMessage);
    }

    private MouseMotionListener getErrorTooltipMouseMotionListener() {
        return new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
                EntityFigure.this.setErrorTooltipConditionally(me);
            }

            public void mouseEntered(MouseEvent me) {
                EntityFigure.this.setErrorTooltipConditionally(me);
            }

            public void mouseExited(MouseEvent me) {
                EntityFigure.this.setErrorTooltipConditionally(me);
            }

            public void mouseHover(MouseEvent me) {
                EntityFigure.this.setErrorTooltipConditionally(me);
            }

            public void mouseMoved(MouseEvent me) {
                EntityFigure.this.setErrorTooltipConditionally(me);
            }
        };
    }

    private void setErrorTooltipConditionally(MouseEvent me) {
        Figure figure = this.getFigureWithError();
        Point errorPoint = figure.getBounds().getTopRight();
        Point point = new Point(me.x, me.y);
        if (20.0 > errorPoint.getDistance(point)) {
            figure.setToolTip((IFigure)this.getErrorLabel());
        } else {
            figure.setToolTip(null);
        }
    }

    protected Figure getFigureWithError() {
        return this;
    }
}

