/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.mule.tooling.images.StudioImages;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.NodeFigure;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorPosition;
import org.mule.tooling.messageflow.figuredecorator.OverlayIcon;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.EndpointDecorator;

public class EndpointFigure
extends NodeFigure {
    private Figure triggerFigure;
    private Label triggerButton;

    public EndpointFigure(EndpointNode endpoint) {
        super((MessageFlowNode)endpoint, endpoint.getType());
        this.createTriggerFigure();
        this.updateImageFigure();
    }

    @Override
    protected OverlayIcon getOverlay(FigureDecoratorPosition pos) {
        switch (pos) {
            case BOTTOM_RIGHT: {
                EndpointDecorator decorator = new EndpointDecorator(this.getEndpointNode());
                if (decorator.isOneWayMEP()) {
                    return new OverlayIcon(StudioImages.OVR_COMPONENT_ONE_WAY, null);
                }
                if (decorator.isRequestResponseMEP()) {
                    return new OverlayIcon(StudioImages.OVR_COMPONENT_REQUEST_RESPONSE, null);
                }
                return null;
            }
            case OUTSIDE: {
                return this.getFigureDecorator().getOverlay(pos);
            }
        }
        return super.getOverlay(pos);
    }

    @Override
    public void updateImageFigure(MessageFlowEntity entity) {
        super.updateImageFigure(entity);
        OverlayIcon overlay = this.getFigureDecorator().getOverlay(FigureDecoratorPosition.OUTSIDE);
        this.updateTriggerButton(overlay);
    }

    private void updateTriggerButton(OverlayIcon overlay) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(overlay);
        if (imageDescriptor != null) {
            if (this.triggerFigure != null && !this.getChildren().contains(this.triggerFigure)) {
                this.triggerButton = new Label(imageDescriptor.createImage());
                this.triggerButton.setIconAlignment(4);
                this.triggerButton.addMouseListener(overlay.getMouseListener());
                this.triggerFigure.add((IFigure)this.triggerButton);
                this.add((IFigure)this.triggerFigure);
            }
        } else if (this.getChildren().contains(this.triggerFigure)) {
            this.remove((IFigure)this.triggerFigure);
        }
    }

    private void createTriggerFigure() {
        this.triggerFigure = new Figure();
        FlowLayout layout = new FlowLayout();
        layout.setMajorAlignment(2);
        layout.setMinorAlignment(2);
        this.triggerFigure.setLayoutManager((LayoutManager)layout);
    }

    public EndpointNode getEndpointNode() {
        return (EndpointNode)this.getEntity();
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
        visitor.visitEndpoint(this);
    }
}

