/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class EllipseDecoration
extends Ellipse
implements RotatableDecoration {
    private static final int RADIUS = 3;
    private Point location = new Point();

    public void setLocation(Point p) {
        this.location = p;
        Rectangle bounds = new Rectangle(this.location.x - 3, this.location.y - 3, 6, 6);
        this.setBounds(bounds);
    }

    public void setReferencePoint(Point p) {
        double d = Math.sqrt(Math.pow(this.location.x - p.x, 2.0) + Math.pow(this.location.y - p.y, 2.0));
        if (d < 3.0) {
            return;
        }
        double k = (d - 3.0) / d;
        double longx = Math.abs(p.x - this.location.x);
        double longy = Math.abs(p.y - this.location.y);
        double shortx = k * longx;
        double shorty = k * longy;
        int rx = this.location.x < p.x ? p.x - (int)shortx : p.x + (int)shortx;
        int ry = this.location.y > p.y ? p.y + (int)shorty : p.y - (int)shorty;
        this.setBounds(new Rectangle(rx - 3, ry - 3, 7, 7));
    }
}

