/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.ArrayList;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;
import org.mule.tooling.messageflow.figure.ResponseTruncatorBendpoint;
import org.mule.tooling.messageflow.layout.FlowDimensionsAware;
import org.mule.tooling.model.messageflow.decorator.Connector;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ConnectorFigure
extends PolylineConnection {
    private Connector connector;
    private PolylineDecoration decoration = new PolylineDecoration();
    public static final PointList TRIANGLE_TIP = new PointList();

    static {
        TRIANGLE_TIP.addPoint(-1, 1);
        TRIANGLE_TIP.addPoint(0, 0);
        TRIANGLE_TIP.addPoint(-1, -1);
    }

    public void setForegroundColor(Color color) {
        super.setForegroundColor(color);
        this.setArrowHead(color);
    }

    public ConnectorFigure(Connector connector) {
        ArrayList<Object> points;
        this.connector = connector;
        this.setForegroundColor(this.getDefaultConnectorColor());
        if (connector.getType() == ConnectorType.RESPONSE_FLOW) {
            this.setForegroundColor(this.getResonseForegroundColor());
        }
        if (connector.getType() == ConnectorType.RESPONSE_TERMINATOR) {
            this.setForegroundColor(this.getResonseForegroundColor());
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
            points = new ArrayList<Object>();
            points.add(new Bendpoint(){

                public Point getLocation() {
                    ConnectionAnchor sourceAnchor = ConnectorFigure.this.getSourceAnchor();
                    PrecisionPoint source = new PrecisionPoint(sourceAnchor.getReferencePoint());
                    ConnectionAnchor targetAnchor = ConnectorFigure.this.getTargetAnchor();
                    PrecisionPoint target = new PrecisionPoint(targetAnchor.getReferencePoint());
                    ConnectorFigure.this.translateToRelative((Translatable)source);
                    ConnectorFigure.this.translateToRelative((Translatable)target);
                    return new Point(source.x, target.y);
                }
            });
            this.setRoutingConstraint(points);
        }
        if (connector.getType() == ConnectorType.RESPONSE_TERMINATOR_2) {
            this.setForegroundColor(this.getResonseForegroundColor());
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
            points = new ArrayList();
            points.add(new ResponseTruncatorBendpoint((Connection)this){

                @Override
                public Point getLocation() {
                    ConnectionAnchor sourceAnchor = this.getConnection().getSourceAnchor();
                    PrecisionPoint a1 = new PrecisionPoint(sourceAnchor.getLocation(sourceAnchor.getReferencePoint()));
                    PrecisionPoint a2 = new PrecisionPoint(this.getConnection().getTargetAnchor().getReferencePoint());
                    this.getConnection().translateToRelative((Translatable)a1);
                    this.getConnection().translateToRelative((Translatable)a2);
                    return new Point(a2.x, a1.y);
                }
            });
            this.setRoutingConstraint(points);
        }
        if (connector.getType() == ConnectorType.RESPONSE_TERMINATOR_3) {
            this.setForegroundColor(this.getResonseForegroundColor());
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
            points = new ArrayList();
            points.add(new ResponseTruncatorBendpoint((Connection)this){

                @Override
                public Point getLocation() {
                    PrecisionPoint a1 = new PrecisionPoint(this.getConnection().getSourceAnchor().getReferencePoint());
                    PrecisionPoint a2 = new PrecisionPoint(this.getConnection().getTargetAnchor().getReferencePoint());
                    this.getConnection().translateToRelative((Translatable)a1);
                    this.getConnection().translateToRelative((Translatable)a2);
                    int middleY = (a1.y + a2.y) / 2;
                    return new Point(a1.x, middleY);
                }
            });
            points.add(new ResponseTruncatorBendpoint((Connection)this){

                @Override
                public Point getLocation() {
                    PrecisionPoint a1 = new PrecisionPoint(this.getConnection().getSourceAnchor().getReferencePoint());
                    PrecisionPoint a2 = new PrecisionPoint(this.getConnection().getTargetAnchor().getReferencePoint());
                    this.getConnection().translateToRelative((Translatable)a1);
                    this.getConnection().translateToRelative((Translatable)a2);
                    int middleY = (a1.y + a2.y) / 2;
                    return new Point(a2.x, middleY);
                }
            });
            this.setRoutingConstraint(points);
        }
        if (connector.getType() == ConnectorType.RESPONSE_TERMINATOR_4) {
            this.setForegroundColor(this.getResonseForegroundColor());
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
            points = new ArrayList();
            points.add(new ResponseTruncatorBendpoint((Connection)this){

                @Override
                public Point getLocation() {
                    PrecisionPoint a1 = new PrecisionPoint(this.getConnection().getSourceAnchor().getReferencePoint());
                    ConnectionAnchor targetAnchor = this.getConnection().getTargetAnchor();
                    PrecisionPoint a2 = new PrecisionPoint(targetAnchor.getReferencePoint());
                    this.getConnection().translateToRelative((Translatable)a1);
                    this.getConnection().translateToRelative((Translatable)a2);
                    IFigure owner = this.getConnection().getSourceAnchor().getOwner();
                    FlowDimensionsAware layoutManager = (FlowDimensionsAware)owner.getParent().getLayoutManager();
                    int responseMiddle = layoutManager.getFlowDimensions().getResponseMiddle();
                    Point point = new Point(a1.x(), owner.getParent().getBounds().y + responseMiddle);
                    return point;
                }
            });
            points.add(new ResponseTruncatorBendpoint((Connection)this){

                @Override
                public Point getLocation() {
                    ConnectionAnchor targetAnchor = this.getConnection().getTargetAnchor();
                    PrecisionPoint a2 = new PrecisionPoint(targetAnchor.getReferencePoint());
                    this.getConnection().translateToRelative((Translatable)a2);
                    IFigure owner = this.getConnection().getSourceAnchor().getOwner();
                    FlowDimensionsAware layoutManager = (FlowDimensionsAware)owner.getParent().getLayoutManager();
                    int responseMiddle = layoutManager.getFlowDimensions().getResponseMiddle();
                    Point point = new Point(a2.x(), owner.getParent().getBounds().y + responseMiddle);
                    return point;
                }
            });
            this.setRoutingConstraint(points);
        }
        if (connector.getType() == ConnectorType.RESPONSE_FLOW_FROM_COMPOSITE) {
            this.setForegroundColor(this.getResonseForegroundColor());
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
            points = new ArrayList();
            points.add(new ResponseTruncatorBendpoint((Connection)this){

                @Override
                public Point getLocation() {
                    PrecisionPoint a1 = new PrecisionPoint(this.getConnection().getSourceAnchor().getReferencePoint());
                    PrecisionPoint a2 = new PrecisionPoint(this.getConnection().getTargetAnchor().getReferencePoint());
                    this.getConnection().translateToRelative((Translatable)a1);
                    this.getConnection().translateToRelative((Translatable)a2);
                    return new Point(a2.x, a1.y);
                }
            });
            this.setRoutingConstraint(points);
        }
        this.applyStyle();
    }

    private void applyStyle() {
        ThemeUtils.applyStylingTo((IFigure)this);
    }

    protected Color getResonseForegroundColor() {
        return FigureColorRegistry.getDefault().get("response.foreground");
    }

    protected Color getDefaultConnectorColor() {
        return FigureColorRegistry.getDefault().get("connector.figure");
    }

    protected void setArrowHead(Color color) {
        this.decoration.setAntialias(1);
        this.decoration.setForegroundColor(color);
        this.decoration.setScale(4.0, 4.0);
        this.setTargetDecoration((RotatableDecoration)this.decoration);
    }

    public Connector getConnector() {
        return this.connector;
    }
}

