/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.mule.tooling.messageflow.layout.FlowDimensions;
import org.mule.tooling.messageflow.layout.FlowDimensionsAware;
import org.mule.tooling.messageflow.layout.FlowDimensionsCalculator;

public class CompartmentLaneLayout
extends AbstractLayout
implements FlowDimensionsAware {
    protected static final int INTER_NODE_SPACING = 35;
    private FlowDimensions flowDimensions;

    public void layout(IFigure nestedContainer) {
        List children = nestedContainer.getChildren();
        FlowDimensionsCalculator calculator = FlowDimensionsCalculator.getInstance();
        FlowDimensions dimensions = calculator.calculate(children);
        this.setFlowDimensions(dimensions);
        int xOffset = 0;
        for (IFigure child : children) {
            Dimension childPrefSize = child.getPreferredSize();
            int distanceToMiddleY = FlowDimensionsCalculator.calculateDistanceToMiddleY(child);
            int yOffset = dimensions.getRequestMiddle() - distanceToMiddleY;
            Rectangle bounds = new Rectangle(xOffset, yOffset, childPrefSize.width, childPrefSize.height);
            this.setBoundsOfChild(nestedContainer, child, bounds);
            xOffset += childPrefSize.width;
            xOffset += 35;
        }
    }

    protected Dimension calculatePreferredSize(IFigure nestedContainer, int wHint, int hHint) {
        int requestHeight;
        List flowChildren = nestedContainer.getChildren();
        FlowDimensions dimensions = FlowDimensionsCalculator.getInstance().calculate(flowChildren);
        this.setFlowDimensions(dimensions);
        int totalWidth = this.calculateWidth(nestedContainer);
        int prefHeight = requestHeight = dimensions.getRequestHeight();
        int insetWidth = nestedContainer.getInsets().getWidth();
        int insetHeight = nestedContainer.getInsets().getHeight();
        Dimension preferred = new Dimension(totalWidth + insetWidth, prefHeight + insetHeight);
        preferred.union(this.getBorderPreferredSize(nestedContainer));
        return preferred;
    }

    protected int calculateWidth(IFigure container) {
        int currWidth = 0;
        List children = container.getChildren();
        for (IFigure child : children) {
            Dimension childPref = child.getPreferredSize();
            currWidth += childPref.width;
        }
        if (children.size() > 0) {
            currWidth += 35 * (children.size() - 1);
        }
        return currWidth;
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    @Override
    public FlowDimensions getFlowDimensions() {
        return this.flowDimensions;
    }

    protected void setFlowDimensions(FlowDimensions flowDimensions) {
        this.flowDimensions = flowDimensions;
    }
}

