/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Font;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.ParagraphTextFlowLabel;
import org.mule.tooling.messageflow.figure.TextFlowLabel;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class CommentFigure
extends EntityFigure<CommentContainer> {
    private ImageFigure imageFigure;
    private TextFlowLabel label;
    private Label descriptionLabel;

    public CommentFigure(CommentContainer node) {
        super(node);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        layout.setSpacing(5);
        this.setLayoutManager((LayoutManager)layout);
        this.imageFigure = new ImageFigure(ImagesManager.getInstance().getCanvasComment());
        this.add((IFigure)this.imageFigure);
        this.label = new ParagraphTextFlowLabel(node.getDisplayName());
        this.descriptionLabel = new Label();
        Font font = this.label.getFont();
        this.descriptionLabel.setFont(font);
        this.descriptionLabel.setForegroundColor(ThemeUtils.getCurrentTheme().getDescriptionForegroundColor());
        this.descriptionLabel.setText("Comment");
        this.add((IFigure)this.descriptionLabel);
        this.add((IFigure)this.label);
        this.setBorder((Border)new MarginBorder(2));
        this.applyStyle();
    }

    @Override
    protected void severityChanged() {
    }

    @Override
    public boolean hasLabel() {
        return true;
    }

    @Override
    public void updateLabel(String value) {
        this.label.setText(value);
    }

    @Override
    public synchronized TextFlowLabel getLabel() {
        return this.label;
    }

    @Override
    public String getLabelText() {
        return this.label.getText();
    }

    @Override
    public void setLabelText(String value) {
        this.label.setText(value);
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
    }
}

