/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.Tuple3;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.EntityFigureVisitor;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;
import org.mule.tooling.messageflow.figure.GreedyFlowLayout;
import org.mule.tooling.messageflow.figure.NestedContainerFigure;
import org.mule.tooling.messageflow.figure.TopLineColoredBorder;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorPosition;
import org.mule.tooling.messageflow.figuredecorator.OverlayIcon;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.ui.widgets.button.CollapseButton;

public class CommentContainerFigure
extends EntityFigure<CommentContainer> {
    public static final int DECORATOR_OFFSET_Y = 4;
    public static final int DECORATOR_OFFSET_X = 3;
    protected int preferredEmptySize = 50;
    private Label titleLabel;
    private Figure titleFigure;
    private Figure footerFigure;
    private Color styleableBorderColor;
    protected CollapseButton collapseFigure;
    private Figure contentFigure;
    protected boolean allowsDirectEditing = true;
    private List<Image> createdImages = new ArrayList<Image>();
    private List<Figure> rowFigures;
    private TopLineColoredBorder lineBorder;

    public CommentContainerFigure(CommentContainer container) {
        super(container);
        ToolbarLayout tbLayout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)tbLayout);
        this.createBorder();
        this.setupTitleFigure();
        this.addTitleFigure();
        this.initListener();
        this.setContentFigure(this.createContentFigure());
        this.addContentFigure();
        this.setupFooterFigure();
        this.addFooterFigure();
        this.applyStyle();
        this.fireFigureMoved();
        this.setBackgroundColor(new Color(new RGB(125, 125, 125)));
        this.setOpaque(false);
    }

    private void initListener() {
    }

    public void setupTitleFigure() {
        this.setTitleFigure(new Figure());
        FlowLayout flowLayout = new FlowLayout(true);
        flowLayout.setStretchMinorAxis(true);
        this.getTitleFigure().setLayoutManager((LayoutManager)flowLayout);
        this.setTitleLabel(new Label());
        this.getTitleFigure().add((IFigure)this.getTitleLabel());
        this.getTitleFigure().setOpaque(true);
        this.getTitleFigure().setBackgroundColor(new Color(new RGB(100, 100, 100)));
        this.getTitleFigure().setForegroundColor(new Color(new RGB(255, 255, 255)));
        MarginBorder titleMargin = new MarginBorder(2, 5, 2, 5);
        this.getTitleFigure().setBorder((Border)titleMargin);
    }

    public void addTitleFigure() {
        super.add((IFigure)this.getTitleFigure(), null, -1);
    }

    private void setupFooterFigure() {
        this.setFooterFigure(new Figure());
        GreedyFlowLayout flowLayout = new GreedyFlowLayout(true);
        this.getFooterFigure().setLayoutManager((LayoutManager)flowLayout);
    }

    public void addFooterFigure() {
        super.add((IFigure)this.getFooterFigure(), null, -1);
    }

    public void removeFooterFigure() {
        super.remove((IFigure)this.getFooterFigure());
    }

    public Figure createContentFigure() {
        Figure newContentFigure = new Figure();
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        newContentFigure.setLayoutManager((LayoutManager)toolbarLayout);
        ImageFigure imageFigure = new ImageFigure(ImagesManager.getInstance().getCanvasCommentContainer());
        newContentFigure.add((IFigure)imageFigure);
        return newContentFigure;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.drawSeparationLines(graphics, this.getContentFigure());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        ImageDescriptor decoratorDescriptor = this.getDecorationImageDescriptor();
        this.paintDecorator(graphics, decoratorDescriptor);
    }

    private void paintDecorator(Graphics graphics, ImageDescriptor decorator) {
        if (decorator != null) {
            Image decoratorImage = decorator.createImage();
            Point pos = this.getDecoratorPosition(decoratorImage);
            graphics.drawImage(decoratorImage, pos.x, pos.y);
            decoratorImage.dispose();
        }
    }

    private Point getDecoratorPosition(Image decoratorImage) {
        int x = this.getBounds().x + this.getBounds().width - decoratorImage.getBounds().width + 3;
        int y = this.getTitleFigure().getBounds().y - 4;
        return new Point(x, y);
    }

    private void drawSeparationLines(Graphics graphics, Figure contentfigure) {
        graphics.setLineStyle(1);
        graphics.setForegroundColor(this.getStyleableBorderColor());
        graphics.setLineWidth(1);
        List<Figure> rowFigures = this.getChildFigures(this.getContentFigure());
        this.drawHorizontalSeparationLines(graphics, rowFigures);
        for (Figure rowFigure : rowFigures) {
            this.drawVerticalSeparationLines(graphics, rowFigure);
        }
    }

    private void drawHorizontalSeparationLines(Graphics graphics, List<Figure> rowFigures) {
        int i = 0;
        while (i < rowFigures.size() - 1) {
            Figure rowFigure = rowFigures.get(i);
            int x = this.getLocation().x;
            int y = rowFigure.getLocation().y + rowFigure.getBounds().height;
            Point left = new Point(x, y);
            Point right = new Point(x + this.getBounds().width, y);
            graphics.drawLine(left, right);
            ++i;
        }
    }

    private List<Figure> getChildFigures(Figure figure) {
        return CoreUtils.filterByType((Iterable)figure.getChildren(), Figure.class);
    }

    private void drawVerticalSeparationLines(Graphics graphics, Figure rowFigure) {
        List<Figure> childFigures = this.getChildFigures(rowFigure);
        int i = 0;
        while (i < childFigures.size() - 1) {
            Figure child = childFigures.get(i);
            Point location = rowFigure.getLocation();
            int x = child.getLocation().x + child.getBounds().width;
            Point top = new Point(x, location.y);
            Point bottom = new Point(x, location.y + rowFigure.getBounds().height);
            top.y += 20;
            bottom.y -= 20;
            graphics.setLineStyle(6);
            graphics.setLineDash(new float[]{3.0f, 2.0f});
            graphics.setLineDashOffset(20.0f);
            graphics.drawLine(top, bottom);
            ++i;
        }
    }

    public Figure getContentFigure() {
        return this.contentFigure;
    }

    public void addContentFigure() {
        super.add((IFigure)this.getContentFigure(), null, -1);
    }

    public void createBorder() {
        TopLineColoredBorder lineBorder = new TopLineColoredBorder(this.getBorderColor(), 1);
        this.setLineBorder(lineBorder);
        this.getLineBorder().setStyle(1);
        this.getLineBorder().setTopBorderColor(new Color(new RGB(0, 127, 212)));
        this.setBorder((Border)this.getLineBorder());
    }

    protected Color getBorderColor() {
        return new Color(new RGB(100, 100, 100));
    }

    @Override
    protected String getDefaultTitleColorString() {
        return "container.title";
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure instanceof NestedContainerFigure) {
            NestedContainerFigure nestedContainer = (NestedContainerFigure)figure;
            Figure rowFigure = this.rowFigures.get(nestedContainer.getRowNumber());
            GridData nestedContainerGridData = new GridData(4, 4, true, true);
            if (nestedContainer.getDefinition().getId().equals("http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane")) {
                nestedContainerGridData = new GridData(1, 4, false, true);
            }
            rowFigure.add((IFigure)nestedContainer, (Object)nestedContainerGridData);
        }
    }

    public void remove(IFigure figure) {
        this.getContentFigure().remove(figure);
    }

    @Override
    protected void severityChanged() {
        this.updateImageFigure();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension pref = super.getPreferredSize(wHint, hHint);
        return new Dimension(Math.max(this.preferredEmptySize, pref.width), Math.max(this.preferredEmptySize, pref.height));
    }

    public void updateLabel() {
        CommentContainer containerNode = (CommentContainer)this.getEntity();
        this.getTitleLabel().setText("Comment - " + containerNode.getDisplayName());
    }

    public void doUpdate() {
        this.updateLabel();
    }

    @Override
    public boolean hasLabel() {
        return true;
    }

    @Override
    public void updateLabel(String value) {
        this.getTitleLabel().setText(value);
    }

    public Label getLabel() {
        return this.getTitleLabel();
    }

    @Override
    public String getLabelText() {
        return this.getTitleLabel().getText();
    }

    @Override
    public void setLabelText(String value) {
        this.getTitleLabel().setText(value);
    }

    public boolean allowsDirectEditing() {
        return this.allowsDirectEditing;
    }

    public void setAllowsDirectEditing(boolean value) {
        this.allowsDirectEditing = value;
    }

    @Override
    public void updateImageFigure() {
        super.updateImageFigure();
        this.updateLabel();
        this.disposeCreatedImages();
        this.getTitleFigure().removeAll();
        this.addOverlayIcon(this.getOverlay(FigureDecoratorPosition.TOP_LEFT), this.getTitleFigure());
        Figure collapse = this.getCollapseFigure();
        if (collapse != null) {
            this.getTitleFigure().add((IFigure)collapse);
        }
        this.getTitleFigure().add((IFigure)this.getTitleLabel());
        this.getTitleFigure().add((IFigure)this.getTitleLabel());
        this.addOverlayIcon(this.getOverlay(FigureDecoratorPosition.TOP_RIGHT), this.getTitleFigure());
        this.updateFooter();
    }

    private void updateFooter() {
        if (this.hasFooterFigure()) {
            MarginBorder footerMargin = new MarginBorder(10, 5, 2, 0);
            this.getFooterFigure().setBorder((Border)footerMargin);
        } else {
            this.getFooterFigure().setBorder(null);
        }
        this.getFooterFigure().removeAll();
        this.addOverlayIcon(this.getOverlay(FigureDecoratorPosition.BOTTOM_LEFT), this.getFooterFigure());
        this.addOverlayIcon(this.getOverlay(FigureDecoratorPosition.BOTTOM_RIGHT), this.getFooterFigure());
    }

    private boolean hasFooterFigure() {
        return this.getOverlay(FigureDecoratorPosition.BOTTOM_LEFT) != null || this.getOverlay(FigureDecoratorPosition.BOTTOM_LEFT) != null;
    }

    protected void disposeCreatedImages() {
        for (Image image : this.getCreatedImages()) {
            if (image == null) continue;
            image.dispose();
        }
        this.getCreatedImages().clear();
    }

    public void addOverlayIcon(OverlayIcon overlay, Figure parent) {
        if (overlay != null) {
            List<Tuple3<ImageDescriptor, MouseListener, Integer>> imageTuples = overlay.getAllImageTuples();
            for (Tuple3<ImageDescriptor, MouseListener, Integer> tuple : imageTuples) {
                ImageFigure newImageFigure = new ImageFigure();
                Image createdImage = ((ImageDescriptor)tuple.first()).createImage();
                newImageFigure.setImage(createdImage);
                this.getCreatedImages().add(createdImage);
                if (tuple.second() != null) {
                    newImageFigure.addMouseListener((MouseListener)tuple.second());
                }
                parent.add((IFigure)newImageFigure);
            }
        }
    }

    public void invalidate() {
        if (this.isValid()) {
            super.invalidate();
            List children = this.getChildren();
            for (Object child : children) {
                ((Figure)child).invalidateTree();
            }
        }
    }

    public void forceRefresh() {
        super.invalidate();
        List children = this.getChildren();
        for (Object child : children) {
            ((Figure)child).invalidateTree();
        }
    }

    public Figure getTitleFigure() {
        return this.titleFigure;
    }

    public void setTitleFigure(Figure titleFigure) {
        this.titleFigure = titleFigure;
    }

    public void setContentFigure(Figure contentFigure) {
        this.contentFigure = contentFigure;
    }

    @Override
    public void accept(EntityFigureVisitor visitor) {
    }

    public Color getTitleFontColor() {
        return FigureColorRegistry.getDefault().get("container.font.color");
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(Label label) {
        this.titleLabel = label;
    }

    public TopLineColoredBorder getLineBorder() {
        return this.lineBorder;
    }

    private void setLineBorder(TopLineColoredBorder lineBorder) {
        this.lineBorder = lineBorder;
    }

    public Color getStyleableBorderColor() {
        if (this.styleableBorderColor == null) {
            return this.getBorderColor();
        }
        return this.styleableBorderColor;
    }

    public void setStyleableBorderColor(Color styleableBorderColor) {
        this.styleableBorderColor = styleableBorderColor;
    }

    public List<Image> getCreatedImages() {
        return this.createdImages;
    }

    public void setCreatedImages(List<Image> createdImages) {
        this.createdImages = createdImages;
    }

    public List<Figure> getRowFigures() {
        return this.rowFigures;
    }

    public Figure getCollapseFigure() {
        return this.collapseFigure;
    }

    public void setCollapseFigure(CollapseButton collapseFigure) {
        this.collapseFigure = collapseFigure;
    }

    public Figure getFooterFigure() {
        return this.footerFigure;
    }

    public void setFooterFigure(Figure footerFigure) {
        this.footerFigure = footerFigure;
    }

    public Insets getInsets() {
        if (this.getDecorationImageDescriptor() != null) {
            return super.getInsets().add(new Insets(0, 0, 0, 12));
        }
        return super.getInsets();
    }
}

