/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.figure;

import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.figure.CompartmentLaneFigure;
import org.mule.tooling.messageflow.figure.NestedContainerFigure;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.widgets.button.CollapseButton;
import org.mule.tooling.ui.widgets.listener.ICollapseListener;

public class CollapsableNestedContainerFigure
extends NestedContainerFigure
implements ICollapseListener {
    private CollapseButton collapseButton;

    public CollapsableNestedContainerFigure(NestedContainer scope, boolean allowEdit, EditPart parentEditPart) {
        super(scope, allowEdit, parentEditPart);
    }

    @Override
    public boolean shouldDisplayTitleHeader() {
        return true;
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension preferredSize = super.getPreferredSize(wHint, hHint);
        if (this.isCollapsed()) {
            return this.getTitleFigure().getMinimumSize();
        }
        return preferredSize;
    }

    @Override
    protected Figure createTitleFigure(NestedContainer nestedContainer, GridLayout parentLayout) {
        Figure newTitleFigure = new Figure();
        parentLayout.setConstraint((IFigure)newTitleFigure, (Object)new GridData(1, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        newTitleFigure.setLayoutManager((LayoutManager)gridLayout);
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        this.createCollapseTracker();
        newTitleFigure.add((IFigure)this.collapseButton, (Object)layoutData);
        if (!StringUtils.isEmpty((String)this.getDisplayName())) {
            GridData constraint = new GridData(64);
            constraint.grabExcessHorizontalSpace = true;
            newTitleFigure.add((IFigure)this.createTitleLabel(nestedContainer), (Object)constraint);
        }
        return newTitleFigure;
    }

    protected void paintFigure(Graphics graphics) {
        for (Object o : this.getChildren()) {
            if (!(o instanceof CompartmentLaneFigure)) continue;
            IFigure figure = (IFigure)o;
            figure.setVisible(!this.isCollapsed());
        }
        super.paintFigure(graphics);
    }

    private void createCollapseTracker() {
        boolean initCollapsed = this.isEmpty();
        boolean isErrorHandler = ModelUtils.isErrorHandler((NodeDefinition)((NestedContainer)this.getEntity()).getDefinition());
        this.collapseButton = new CollapseButton(initCollapsed, ((NestedContainer)this.getEntity()).getDefinition().getCategoryId(), isErrorHandler);
        this.collapseButton.addListener((ICollapseListener)this);
    }

    private boolean isCollapsed() {
        return this.collapseButton.isCollapsed();
    }

    public void forceExpand() {
        if (this.collapseButton.isCollapsed()) {
            this.collapseButton.reset();
        }
    }

    public void onCollapse() {
        EntityEditPart<?> editPart = MessageFlowEditor.findEditPartInRegistry(this.parentEditPart.getViewer(), this.getEntity());
        if (editPart != null) {
            this.hideChildrenConnections(editPart);
        }
    }

    public void onExpand() {
        EntityEditPart<?> editPart = MessageFlowEditor.findEditPartInRegistry(this.parentEditPart.getViewer(), this.getEntity());
        if (editPart != null) {
            this.showChildrenConnections(editPart);
        }
    }

    private void hideChildrenConnections(AbstractGraphicalEditPart part) {
        MessageFlowUtils.hideFlowComponentConnections(part);
    }

    private void showChildrenConnections(AbstractGraphicalEditPart part) {
        MessageFlowUtils.showFlowComponentConnections(part);
    }
}

