/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.explorer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.IconsLocator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.ApiSpecClasspathContainer;
import org.mule.tooling.core.runtime.ExternalContributionClasspathContainerInitializer;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;
import org.mule.tooling.images.StudioImages;
import org.mule.tooling.messageflow.Activator;
import org.mule.tooling.messageflow.explorer.MuleExplorerUtils;
import org.mule.tooling.platform.dependencymanagement.MavenDependencyClasspathContainer;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.utils.reflect.ReflectionUtils;

public class WrapperLabelProvider
extends DecoratingJavaLabelProvider {
    private static final String ERROR_ICON = "An error occurred while getting image";
    private Image muleImage = StudioImages.OBJ_MULE.createImage();
    private Image apiImage = new Image(this.muleImage.getDevice(), this.muleImage, 1);

    public WrapperLabelProvider(JavaUILabelProvider iBaseLabelProvider, boolean flatPackageMode) {
        super(iBaseLabelProvider, true, flatPackageMode);
    }

    public Image getImage(Object element) {
        Image image;
        ClassPathContainer classPathContainer;
        IClasspathEntry entry;
        Image image2;
        if (element instanceof ClassPathContainer && (image2 = this.getClasspathContainerImage(entry = (classPathContainer = (ClassPathContainer)element).getClasspathEntry())) != null) {
            return this.decorateElement(element, image2);
        }
        if (element instanceof IJavaProject) {
            try {
                Image image3;
                IJavaProject javaProject = (IJavaProject)element;
                if (javaProject.getProject().isAccessible() && (image3 = this.getJavaProjectImage(javaProject)) != null) {
                    return this.decorateElement(element, image3);
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)ERROR_ICON, (Throwable)e);
            }
        }
        if (element instanceof IPackageFragmentRoot && MuleExplorerUtils.isMuleApp((IPackageFragmentRoot)element) && (image = Activator.getImages().getImageDescriptor("icons/mule-config-folder-16x16.png").createImage()) != null) {
            return this.decorateElement(element, image);
        }
        if (element instanceof JarPackageFragmentRoot && MuleExplorerUtils.isDataWeaveLibrary((JarPackageFragmentRoot)element) && (image = Activator.getImages().getImageDescriptor("icons/data-weave-16x16.png").createImage()) != null) {
            return this.decorateElement(element, image);
        }
        if (element instanceof JarEntryFile && MuleExplorerUtils.isExternalConfiguration((JarEntryFile)element) && (image = Activator.getImages().getImageDescriptor("icons/Mule-ReadOnly-16x16.png").createImage()) != null) {
            return this.decorateElement(element, image);
        }
        return super.getImage(element);
    }

    private Image getClasspathContainerImage(IClasspathEntry entry) {
        IPath path = entry.getPath();
        Image image = null;
        if (ApiSpecClasspathContainer.isApiSpec((IClasspathEntry)entry) || MavenDependencyClasspathContainer.isMavenDep((IClasspathEntry)entry)) {
            image = this.apiImage;
        } else if (ExternalContributionClasspathContainerInitializer.isMuleLibraryContainer((IPath)path)) {
            String coordinates = MuleUserLibraryClasspathContainer.getCoordinatesFromPath((IPath)path);
            image = Optional.ofNullable(IconsLocator.getImage((String)("connector:/" + coordinates + "/palette-icon.png"))).orElse(this.muleImage);
        } else if (MuleClasspathContainer.isMuleRuntime((IClasspathEntry)entry) || MuleUserLibraryClasspathContainer.isMuleLibrary((IClasspathEntry)entry)) {
            image = this.muleImage;
        }
        return image;
    }

    private Image getJavaProjectImage(IJavaProject javaProject) throws CoreException {
        Image image = null;
        if (MuleProjectKind.APPLICATION.classifies(javaProject.getProject())) {
            image = MuleImages.MULE_PROJECT_PACKAGE_EXPLORER;
        } else if (MuleProjectKind.DOMAIN.classifies(javaProject.getProject())) {
            image = MuleImages.DOMAIN_PROJECT_PACKAGE_EXPLORER;
        } else if (CoreUtils.hasNature((IProject)javaProject.getProject(), (String)"org.mule.tooling.apidesigner.apiprojectnature")) {
            image = MuleImages.API_PROJECT_PACKAGE_EXPLORER;
        } else if (CoreUtils.hasSDKNature((IProject)javaProject.getProject())) {
            image = MuleImages.SDK_PROJECT_PACKAGE_EXPLORER;
        }
        return image;
    }

    private Image decorateElement(Object element, Image image) {
        ILabelDecorator decorator;
        try {
            Field styledLabelProviderField = ReflectionUtils.searchFieldByName(super.getClass(), (String)"styledLabelProvider");
            styledLabelProviderField.setAccessible(true);
            DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider = (DelegatingStyledCellLabelProvider.IStyledLabelProvider)styledLabelProviderField.get((Object)this);
            if (styledLabelProvider instanceof JavaUILabelProvider) {
                JavaUILabelProvider labelProvider = (JavaUILabelProvider)styledLabelProvider;
                Method method = ReflectionUtils.searchMethod(labelProvider.getClass(), (String)"decorateImage", (int)2);
                Object img = ReflectionUtils.invokeMethod((Object)labelProvider, (Method)method, (Object[])new Object[]{image, element});
                if (img instanceof Image) {
                    image = (Image)img;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            MuleCorePlugin.logError((String)ERROR_ICON, (Throwable)e);
        }
        if ((decorator = this.getLabelDecorator()) instanceof LabelDecorator) {
            image = ((LabelDecorator)decorator).decorateImage(image, element, this.getDecorationContext());
        } else if (decorator != null) {
            image = decorator.decorateImage(image, element);
        }
        return image;
    }

    public void dispose() {
        super.dispose();
        this.muleImage.dispose();
        this.apiImage.dispose();
    }
}

