/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.explorer;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.internal.Workbench;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.MuleConfiguration;

public class MultiPageMessageFlowEditorOverride
implements IEditorAssociationOverride {
    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        return editorInput != null ? this.overrideEditors(editorInput.getName(), contentType, editorDescriptors) : editorDescriptors;
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        return (IEditorDescriptor[])Arrays.stream(editorDescriptors).map(descriptor -> this.getEditorDescriptorForFile((IEditorDescriptor)descriptor, fileName)).toArray(IEditorDescriptor[]::new);
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        return editorInput != null ? this.overrideDefaultEditor(editorInput.getName(), contentType, editorDescriptor) : editorDescriptor;
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        return this.getEditorDescriptorForFile(editorDescriptor, fileName);
    }

    private IEditorDescriptor getEditorDescriptorForFile(IEditorDescriptor descriptor, String fileName) {
        JarEntryFile entryFile;
        TreeSelection treeSelection;
        Object element;
        ISelection selection;
        ISelectionService service;
        IWorkbenchWindow workbench;
        if (fileName != null && !fileName.isEmpty() && fileName.endsWith("xml") && (workbench = Workbench.getInstance().getActiveWorkbenchWindow()) != null && (service = workbench.getSelectionService()) != null && (selection = service.getSelection()) instanceof TreeSelection && (element = (treeSelection = (TreeSelection)selection).getFirstElement()) instanceof JarEntryFile && (entryFile = (JarEntryFile)element).getName().equals(fileName)) {
            IJavaProject project = entryFile.getPackageFragmentRoot().getJavaProject();
            IMuleProject muleProject = MuleRuntime.create((IProject)project.getProject());
            for (MuleConfiguration muleConfiguration : muleProject.getConfigurationsCache().getExternalConfigurations()) {
                if (!muleConfiguration.getName().equals(fileName)) continue;
                IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
                IContentType contentType = Platform.getContentTypeManager().getContentType("org.mule.tooling.messageflow.xmlConfig.contentType");
                return editorReg.getDefaultEditor(fileName, contentType);
            }
        }
        return descriptor;
    }
}

