/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.explorer;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.MuleConfiguration;

public class MuleExplorerUtils {
    public static boolean isMuleApp(IPackageFragmentRoot packageFragment) {
        return packageFragment.getPath().toPortableString().endsWith("src/main/mule");
    }

    public static boolean isDataWeaveLibrary(JarPackageFragmentRoot packageFragment) {
        return packageFragment.getPath().toPortableString().contains("dw-library");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExternalConfiguration(JarEntryFile jarEntryFile) {
        IProject project = jarEntryFile.getPackageFragmentRoot().getJavaProject().getProject();
        try {
            MuleConfiguration muleConfiguration;
            if (!project.isOpen()) return false;
            if (!CoreUtils.hasMuleNature((IProject)project)) {
                if (!CoreUtils.hasMuleDomainNature((IProject)project)) return false;
            }
            IMuleProject muleProject = MuleRuntime.create((IProject)project);
            Iterator iterator = muleProject.getConfigurationsCache().getExternalConfigurations().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(muleConfiguration = (MuleConfiguration)iterator.next()).getName().equals(jarEntryFile.getName()));
            return true;
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)("There was a problem evaluating if the project " + project.getName() + " is a Mule project"), (Throwable)e);
        }
        return false;
    }
}

