/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.explorer;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetAwareJavaElementSorter;
import org.eclipse.jface.viewers.Viewer;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.Activator;
import org.mule.tooling.messageflow.explorer.ApiSpecExplorerComparator;
import org.mule.tooling.messageflow.explorer.MuleExplorerComparator;

public class MuleExplorerSorter
extends WorkingSetAwareJavaElementSorter {
    public MuleExplorerSorter(boolean sortPFRByName) {
        super(sortPFRByName);
    }

    public int compare(Viewer viewer, Object element1, Object element2) {
        try {
            if (this.isFromMuleProject(element1) && this.isFromMuleProject(element2)) {
                int compare = new MuleExplorerComparator().compare(element1, element2);
                if (compare == 0) {
                    return this.compareWithPackageFragmentRootContainer(viewer, element1, element2);
                }
                return compare;
            }
            if (this.isFromApiSpecProject(element1) && this.isFromApiSpecProject(element2)) {
                int compare = new ApiSpecExplorerComparator().compare(element1, element2);
                if (compare == 0) {
                    return this.compareWithPackageFragmentRootContainer(viewer, element1, element2);
                }
                return compare;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(Activator.createStatus(4, MessageFormat.format("Error when trying to sort projects from {0} and {1}", element1, element2), e));
        }
        return super.compare(viewer, element1, element2);
    }

    private int compareWithPackageFragmentRootContainer(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof PackageFragmentRootContainer && e2 instanceof PackageFragmentRootContainer) {
            String name1 = ((PackageFragmentRootContainer)e1).getLabel();
            String name2 = ((PackageFragmentRootContainer)e2).getLabel();
            int cmp = this.getComparator().compare(name1, name2);
            if (cmp != 0) {
                return cmp;
            }
        }
        return super.compare(viewer, e1, e2);
    }

    private boolean isFromMuleProject(Object element) throws CoreException {
        IProject project = this.getProject(element);
        if (project != null) {
            return CoreUtils.hasMuleDomainNature((IProject)project) || CoreUtils.hasMuleNature((IProject)project);
        }
        return false;
    }

    private boolean isFromApiSpecProject(Object element) throws CoreException {
        IProject project = this.getProject(element);
        if (project != null) {
            return CoreUtils.hasNature((IProject)project, (String)"org.mule.tooling.apidesigner.apiprojectnature");
        }
        return false;
    }

    private IProject getProject(Object element) {
        if (element instanceof ClassPathContainer) {
            return ((ClassPathContainer)element).getJavaProject().getProject();
        }
        IResource resource = this.getAdapter(element, IResource.class);
        if (resource != null) {
            return resource.getProject();
        }
        IJavaElement javaElement = this.getAdapter(element, IJavaElement.class);
        if (javaElement != null) {
            return javaElement.getJavaProject().getProject();
        }
        return null;
    }

    private <T> T getAdapter(Object element, Class<T> clazz) {
        IAdaptable adaptable;
        Object adapted;
        if (element instanceof IAdaptable && (adapted = (adaptable = (IAdaptable)element).getAdapter(clazz)) != null) {
            return clazz.cast(adapted);
        }
        Object adapted2 = Platform.getAdapterManager().getAdapter(element, IResource.class);
        if (adapted2 != null) {
            return clazz.cast(adapted2);
        }
        return null;
    }
}

