/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.explorer;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectModifiedListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.ApiSpecClasspathContainer;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;
import org.mule.tooling.messageflow.explorer.ImageDescriptorRegistry;
import org.mule.tooling.messageflow.explorer.MuleExplorerUtils;
import org.mule.tooling.platform.dependencymanagement.MavenDependencyClasspathContainer;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.jface.MuleLabelProvider;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MuleExplorerLabelDecorator
implements ILightweightLabelDecorator,
IMuleProjectModifiedListener {
    private static final String FLOWS_FOLDER_SUFFIX = " (Flows)";
    private ImageDescriptorRegistry imagesRegistry;
    private Collection<ILabelProviderListener> listeners = new HashSet<ILabelProviderListener>();
    private ProblemsLabelDecorator problemsLabelDecorator = new ProblemsLabelDecorator();
    private EventBusHelper eventBusHelper = new EventBusHelper();

    public MuleExplorerLabelDecorator() {
        this.registerMuleProjectListener();
    }

    private void registerMuleProjectListener() {
        if (MuleCorePlugin.getEventBus() != null) {
            this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_PROJECT_MODIFIED, (IEventHandler)this);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        if (this.imagesRegistry != null) {
            this.imagesRegistry.dispose();
            this.imagesRegistry = null;
        }
        if (this.eventBusHelper != null) {
            this.eventBusHelper.unregister();
            this.eventBusHelper = null;
        }
        if (this.problemsLabelDecorator != null) {
            this.problemsLabelDecorator.dispose();
            this.problemsLabelDecorator = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    private void runWithoutNotifications(Runnable supplier) {
        this.eventBusHelper.unregister();
        try {
            supplier.run();
        }
        finally {
            this.registerMuleProjectListener();
        }
    }

    protected ImageDescriptorRegistry getImageRegistry() {
        if (this.imagesRegistry == null) {
            this.imagesRegistry = new ImageDescriptorRegistry();
        }
        return this.imagesRegistry;
    }

    private String getProjectModelFileSuffix(IFile file) {
        Object result = "";
        IProject project = file.getProject();
        try {
            IServerDefinition serverDefinition;
            IMuleProject muleProject;
            if (MuleProjectKind.APPLICATION.classifies(project) && (muleProject = this.getMuleProject(project)) != null && (serverDefinition = muleProject.getServerDefinition()) != null) {
                result = " [" + serverDefinition.getLabel() + "]";
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem trying to get the classifier of a project for label decoration", (Throwable)e);
        }
        return result;
    }

    private IMuleProject getMuleProject(IProject project) {
        IMuleProject muleProject = null;
        if (project.isAccessible()) {
            muleProject = MuleRuntime.create((IProject)project);
        }
        return muleProject;
    }

    public void onMuleProjectModified(IMuleProject muleProject, String propertyName) {
        if ("prop_domain".equals(propertyName) || "prop_domain_name".equals(propertyName)) {
            Display currentDisplay = Display.getCurrent();
            final LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
            for (final ILabelProviderListener listener : this.listeners) {
                if (currentDisplay == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            listener.labelProviderChanged(event);
                        }
                    });
                    continue;
                }
                listener.labelProviderChanged(event);
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        this.runWithoutNotifications(() -> {
            ClassPathContainer classPathContainer;
            IClasspathEntry entry;
            if (element instanceof IFile) {
                String projectModelFileSuffix;
                IFile file = (IFile)element;
                if ("pom.xml".equals(file.getName()) && StringUtils.isNotBlank((CharSequence)(projectModelFileSuffix = this.getProjectModelFileSuffix(file)))) {
                    decoration.addSuffix(projectModelFileSuffix);
                }
            } else if (element instanceof IPackageFragmentRoot) {
                if (MuleExplorerUtils.isMuleApp((IPackageFragmentRoot)element)) {
                    decoration.addSuffix(FLOWS_FOLDER_SUFFIX);
                }
            } else if (element instanceof IJavaProject) {
                IJavaProject javaProject = (IJavaProject)element;
                String projectSuffix = MuleLabelProvider.getProjectSuffix((IProject)javaProject.getProject());
                if (StringUtils.isNotBlank((CharSequence)projectSuffix)) {
                    decoration.addSuffix(projectSuffix);
                }
            } else if (element instanceof ClassPathContainer && (MuleClasspathContainer.isMuleRuntime((IClasspathEntry)(entry = (classPathContainer = (ClassPathContainer)element).getClasspathEntry())) || MuleUserLibraryClasspathContainer.isMuleLibrary((IClasspathEntry)entry) || ApiSpecClasspathContainer.isApiSpec((IClasspathEntry)entry) || MavenDependencyClasspathContainer.isMavenDep((IClasspathEntry)entry))) {
                decoration.addOverlay(MuleImages.DESC_CLASSPATH_OVR);
            }
        });
    }
}

