/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpolicy;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.messageflow.editpolicy.EditPolicyFactory;

public class ContainerEditPolicyFactoryManager {
    private static ContainerEditPolicyFactoryManager instance;
    private Map<String, EditPolicyFactory> idToEditPolicyFactoryMap = Maps.newHashMap();

    public static ContainerEditPolicyFactoryManager instance() {
        if (instance == null) {
            instance = new ContainerEditPolicyFactoryManager();
        }
        return instance;
    }

    private ContainerEditPolicyFactoryManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.containerEditPolicyFactory");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String editPolicyId = configurationElement.getAttribute("editPolicyFactoryId");
                EditPolicyFactory editPolicyFactory = this.instantiateEditPolicyFactory(configurationElement);
                this.idToEditPolicyFactoryMap.put(editPolicyId, editPolicyFactory);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Failed loading container edit policy extension point", e);
        }
    }

    public Optional<EditPolicyFactory> getEditPolicyFactory(String editPolicyFactoryId) {
        return Optional.fromNullable((Object)this.idToEditPolicyFactoryMap.get(editPolicyFactoryId));
    }

    protected EditPolicyFactory instantiateEditPolicyFactory(IConfigurationElement configurationElement) throws CoreException {
        return (EditPolicyFactory)EditPolicyFactory.class.cast(configurationElement.createExecutableExtension("editPolicyFactoryClass"));
    }
}

