/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AddCompartmentLaneCommand;
import org.mule.tooling.messageflow.command.CloneEntityToFlowControlCommand;
import org.mule.tooling.messageflow.command.MoveEntityCommand;
import org.mule.tooling.messageflow.command.ReparentEntityToSplitterCommand;
import org.mule.tooling.messageflow.command.TransactionalCompoundCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.AddCreateCommandsVisitor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.MuleSelectionEditPolicy;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.util.CloneEntityVisitor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;

public class SplitterLayoutEditPolicy
extends FlowLayoutEditPolicy {
    private static final String RAISE_ERROR_DEFINITION_ID = "http://www.mulesoft.org/schema/mule/core/raise-error";

    protected Command createAddCommand(EditPart child, EditPart after) {
        EntityDecorator parentDecorator = (EntityDecorator)child.getParent().getModel();
        if (this.getHost().getModel() == parentDecorator || MessageFlowUtils.isFlowOrSubflowEditPart(child)) {
            return null;
        }
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        if (!(parentDecorator instanceof ContainerOfMovableEntities)) {
            return null;
        }
        ContainerOfMovableEntities oldContainer = (ContainerOfMovableEntities)parentDecorator;
        if (!ModelUtils.isUnknownNode((IMessageFlowEntity)messageFlowEntity) && !ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity) && this.isException((MessageFlowNode)messageFlowEntity)) {
            return null;
        }
        NodeDefinition childDefinition = MessageFlowUtils.getDefinition(messageFlowEntity);
        if (!ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity) && !this.canGenerateCommand(childDefinition)) {
            return null;
        }
        SplitterEditPart host = (SplitterEditPart)this.getHost();
        ReparentEntityToSplitterCommand cmd = new ReparentEntityToSplitterCommand(host.getCompartment(), messageFlowEntity, this.getSplitterEditPart().getMuleConfiguration(), this.getSplitterEditPart());
        EditPart compartmentEditPart = child.getParent().getParent();
        cmd.setOldCompartment(compartmentEditPart.getModel());
        if (compartmentEditPart.getParent() != null && compartmentEditPart.getParent() instanceof SplitterEditPart) {
            cmd.setSplitter(true);
        }
        cmd.setOldContainer(oldContainer);
        cmd.setRootEditPart((EditPart)this.getHost().getParent().getRoot());
        if (!cmd.canExecute()) {
            System.out.println("cannot execute");
        }
        return cmd;
    }

    protected boolean canGenerateCommand(NodeDefinition childDefinition) {
        SplitterNode hostEntity = (SplitterNode)this.getSplitterEditPart().getEntity();
        NodeDefinition scopeDefinition = MessageFlowUtils.getDefinition((IMessageFlowEntity)hostEntity);
        return childDefinition.getAcceptedByFilter().accepts((IMessageFlowNode)hostEntity, scopeDefinition, ModuleManagerNodeDefinitionResolver.get());
    }

    protected Command getCloneCommand(ChangeBoundsRequest req) {
        ChangeBoundsRequest request = req;
        List editParts = request.getEditParts();
        TransactionalCompoundCommand command = new TransactionalCompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createCloneCommand(child));
            if (editParts.size() > 1) {
                this.adjustIndexes(command);
            }
            ++i;
        }
        return command.unwrap();
    }

    private Command createCloneCommand(EditPart child) {
        if (MessageFlowUtils.isFlowOrSubflowEditPart(child)) {
            return null;
        }
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        if (!(messageFlowEntity instanceof UnknownNode) && this.isException((MessageFlowNode)messageFlowEntity)) {
            return null;
        }
        NodeDefinition childDefinition = MessageFlowUtils.getDefinition(messageFlowEntity);
        if (!this.canGenerateCommand(childDefinition)) {
            return null;
        }
        ContainerOfMovableEntities model = (ContainerOfMovableEntities)this.getHost().getModel();
        CloneEntityVisitor cloneEntityVisitor = new CloneEntityVisitor(model, this.getSplitterEditPart().getMuleConfiguration(), MuleCorePlugin.getDesignContext().getMuleProject());
        CloneEntityToFlowControlCommand cmd = new CloneEntityToFlowControlCommand(this.getSplitterEditPart(), ((SplitterEditPart)this.getHost()).getCompartment(), this.getHost().getParent(), messageFlowEntity, cloneEntityVisitor);
        return cmd;
    }

    private void adjustIndexes(CompoundCommand compoundCommand) {
        List commands = compoundCommand.getCommands();
        int i = 1;
        while (i < commands.size()) {
            MoveEntityCommand addCommand = (MoveEntityCommand)commands.get(i);
            addCommand.setIndex(((MoveEntityCommand)commands.get(i - 1)).getIndex() + 1);
            ++i;
        }
    }

    private boolean isException(MessageFlowNode mn) {
        NodeDefinition definition = mn.getDefinition();
        return this.isExceptionStrategyCategory(definition);
    }

    protected Command getCreateCommand(CreateRequest request) {
        CompartmentLaneDecorator laneDecorator;
        SplitterNode splitterNode = (SplitterNode)this.getSplitterEditPart().getEntity();
        CompartmentDecorator compartment = this.getSplitterEditPart().getCompartment();
        boolean reusingEmptyLane = true;
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)this.getSplitterEditPart().getMuleConfiguration());
        context.getEntityStack().push(splitterNode);
        CompartmentLane emptyLane = compartment.getEmptyLane();
        if (emptyLane == null) {
            reusingEmptyLane = false;
            context.getEntityStack().push(this.getSplitterNode());
            emptyLane = MessageFlowFactory.createCompartmentLane((IFlowTransformerContext)context);
            laneDecorator = new CompartmentLaneDecorator(emptyLane, true);
        } else {
            EntityEditPart<?> emptyLanePart = MessageFlowEditor.findEditPartInRegistry(this.getSplitterEditPart().getViewer(), (IMessageFlowEntity)emptyLane);
            if (emptyLanePart != null) {
                laneDecorator = (CompartmentLaneDecorator)emptyLanePart.getEntityDecorator();
            } else {
                reusingEmptyLane = false;
                emptyLane = MessageFlowFactory.createCompartmentLane((IFlowTransformerContext)context);
                laneDecorator = new CompartmentLaneDecorator(emptyLane, true);
            }
        }
        EntityEditPart<?> compEditPart = MessageFlowEditor.findEditPartInRegistry(this.getSplitterEditPart().getViewer(), compartment.getEntity());
        Object newObject = request.getNewObject();
        if (!(newObject instanceof NodeDefinition)) {
            return null;
        }
        NodeDefinition nodeDefinition = (NodeDefinition)newObject;
        if (this.isExceptionStrategyCategory(nodeDefinition)) {
            return null;
        }
        if (!this.canGenerateCommand(nodeDefinition)) {
            return null;
        }
        MessageFlowFactory.configureNextCompartmentLane((Compartment)((Compartment)compartment.getEntity()));
        CompoundCommand command = new CompoundCommand();
        AddCreateCommandsVisitor addCreateCommandsVisitor = new AddCreateCommandsVisitor(command, (CompartmentLaneDecorator<?>)laneDecorator, (EditPart)this.getHost(), (EditPart)compEditPart);
        nodeDefinition.accept((NodeDefinitionVisitor)addCreateCommandsVisitor);
        if (!addCreateCommandsVisitor.didAddCommand()) {
            return null;
        }
        if (!reusingEmptyLane) {
            command.add((Command)new AddCompartmentLaneCommand(compartment, emptyLane));
        }
        return command;
    }

    protected boolean isExceptionStrategyCategory(NodeDefinition nodeDefinition) {
        return nodeDefinition.getCategoryId().equals(Category.EXCEPTIONS.getCategoryString()) && !nodeDefinition.getId().equals(RAISE_ERROR_DEFINITION_ID);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new MuleSelectionEditPolicy();
    }

    protected SplitterEditPart getSplitterEditPart() {
        return (SplitterEditPart)this.getHost();
    }

    protected SplitterNode getSplitterNode() {
        return (SplitterNode)this.getSplitterEditPart().getEntity();
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        return null;
    }
}

