/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CenterpointAnchor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.SplitterLayoutEditPolicy;
import org.mule.tooling.messageflow.figure.SplitterFigure;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.PatternDecorator;
import org.mule.tooling.model.messageflow.decorator.SplitterDecorator;

public class SplitterEditPart
extends EntityEditPart<SplitterNode>
implements NodeEditPart {
    private List<EntityDecorator<?>> displayModel;
    private PatternDecorator pattern;
    private CompartmentDecorator compartment;

    public SplitterEditPart(SplitterDecorator decorator) {
        super(decorator);
    }

    @Override
    public void activate() {
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    @Override
    protected IFigure createFigure() {
        SplitterFigure splitterFigure = new SplitterFigure((SplitterNode)this.getEntity());
        return splitterFigure;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installSplitterEditPolicy();
    }

    protected void installSplitterEditPolicy() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SplitterLayoutEditPolicy());
    }

    protected List getModelChildren() {
        if (this.displayModel == null) {
            this.displayModel = this.buildDisplayModel();
        }
        return this.displayModel;
    }

    protected void flushModel() {
        this.displayModel = null;
    }

    protected List<EntityDecorator<?>> buildDisplayModel() {
        PatternDecorator pattern = this.getOrCreatePatternDecorator();
        this.setPatternDecorator(pattern);
        CompartmentDecorator compartment = this.getOrCreateCompartmentDecorator();
        this.setCompartmentDecorator(compartment);
        ArrayList model = new ArrayList();
        model.add((EntityDecorator<?>)pattern);
        model.add((EntityDecorator<?>)compartment);
        return model;
    }

    protected CompartmentDecorator getOrCreateCompartmentDecorator() {
        EntityEditPart<?> compEditPart = MessageFlowEditor.findEditPartInRegistry(this.getRoot().getViewer(), (IMessageFlowEntity)((SplitterNode)this.getEntity()).getCompartment());
        CompartmentDecorator compartment = compEditPart != null ? (CompartmentDecorator)compEditPart.getEntityDecorator() : new CompartmentDecorator(((SplitterNode)this.getEntity()).getCompartment(), true);
        return compartment;
    }

    protected PatternDecorator getOrCreatePatternDecorator() {
        EntityEditPart<?> patternEditPart = MessageFlowEditor.findEditPartInRegistry(this.getRoot().getViewer(), (IMessageFlowEntity)((SplitterNode)this.getEntity()).getPattern());
        PatternDecorator pattern = patternEditPart != null ? (PatternDecorator)patternEditPart.getEntityDecorator() : new PatternDecorator(((SplitterNode)this.getEntity()).getPattern());
        return pattern;
    }

    protected void setCompartmentDecorator(CompartmentDecorator compartmentDecorator) {
        this.compartment = compartmentDecorator;
    }

    protected void setPatternDecorator(PatternDecorator patternDecorator) {
        this.pattern = patternDecorator;
    }

    @Override
    public void updateFigure() {
        this.flushModel();
        this.refreshChildren();
        super.updateFigure();
        EntityEditPart<?> patternEditPart = MessageFlowEditor.findEditPartInRegistry(this.getRoot().getViewer(), (IMessageFlowEntity)((SplitterNode)this.getEntity()).getPattern());
        patternEditPart.updateFigure();
    }

    public void refresh() {
        this.refreshSourceConnections();
        this.refreshTargetConnections();
        this.updateFigure();
    }

    public CompartmentDecorator getCompartment() {
        return this.compartment;
    }

    public PatternDecorator getPattern() {
        return this.pattern;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new CenterpointAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new CenterpointAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    @Override
    protected List<EditPart> getErrorMarkersParticipants() {
        List children = this.getChildren();
        return children.size() <= 1 ? Collections.EMPTY_LIST : children.subList(1, children.size());
    }
}

