/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IConfigurableElement;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.CompartmentLaneEditPart;
import org.mule.tooling.messageflow.editpart.PatternEditPart;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.SplitterDefinition;

public class SplitterCompartmentEditPart
extends CompartmentEditPart {
    public SplitterCompartmentEditPart(EntityDecorator<Compartment> decorator) {
        super(decorator);
    }

    @Override
    protected List<EntityDecorator<?>> buildDisplayModel() {
        SplitterEditPart splitter = (SplitterEditPart)this.getParent();
        Optional<PatternEditPart> patternMaybe = this.getPatternEditPart(splitter);
        Optional<EntityDecorator> splitterPatternMaybe = patternMaybe.map(pattern -> pattern.getEntityDecorator());
        splitterPatternMaybe.ifPresent(pattern -> pattern.getOutbound().clear());
        ArrayList model = new ArrayList();
        List lanes = ((Compartment)this.getEntity()).getLanes();
        this.addMissingRoutes(splitter, lanes);
        this.sortRoutes(lanes);
        this.configureNextRoute(lanes);
        for (CompartmentLane lane : lanes) {
            CompartmentLaneEditPart laneEditPart = this.getLaneEditPart(lane);
            CompartmentLaneDecorator<?> laneDecorator = this.getLaneDecorator(laneEditPart, lane);
            model.add((EntityDecorator<?>)laneDecorator);
            if (splitterPatternMaybe.isPresent() && (lane instanceof Route || !lane.getCompartmentLaneEntries().isEmpty())) {
                MessageFlowFactory.createConnector((EntityDecorator)splitterPatternMaybe.get(), laneDecorator, (ConnectorType)ConnectorType.REQUEST_FLOW);
                laneDecorator.setShowResponse(false);
            }
            if (laneEditPart == null) continue;
            laneEditPart.updateConnections();
        }
        patternMaybe.ifPresent(pattern -> pattern.updateOutbound());
        return model;
    }

    private void addMissingRoutes(SplitterEditPart splitter, List<CompartmentLane> lanes) {
        SplitterDefinition splitterDef;
        SplitterNode splitterNode = (SplitterNode)splitter.getEntity();
        NodeDefinition def = splitterNode.getDefinition();
        if (def instanceof SplitterDefinition && !this.hasAllNeddedRoutes(lanes, splitterDef = (SplitterDefinition)splitterNode.getDefinition())) {
            IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)this.getMuleConfiguration());
            context.getEntityStack().push(splitterNode);
            this.getRemainingRoutes(lanes, splitterDef).forEach(routeDef -> this.getEntityDecorator().addLane((CompartmentLane)MessageFlowFactory.createRoute((IFlowTransformerContext)context, (RouteDefinition)routeDef)));
        }
    }

    @Override
    public CompartmentDecorator getEntityDecorator() {
        return super.getEntityDecorator();
    }

    private List<RouteDefinition> getRemainingRoutes(List<CompartmentLane> lanes, SplitterDefinition splitterDef) {
        ArrayList routeDefinitions = Lists.newArrayList((Iterable)splitterDef.getRouteDefinitions());
        List existingDefinitions = this.getDefinitions(lanes).collect(Collectors.toList());
        routeDefinitions.removeAll(existingDefinitions);
        return routeDefinitions;
    }

    private boolean hasAllNeddedRoutes(List<CompartmentLane> lanes, SplitterDefinition splitterDef) {
        return splitterDef.getRouteDefinitions().stream().allMatch(routeDef -> this.routeIsPresent(lanes, (RouteDefinition)routeDef));
    }

    private boolean routeIsPresent(List<CompartmentLane> lanes, RouteDefinition routeDef) {
        return this.getDefinitions(lanes).anyMatch(def -> def.getId().equals(routeDef.getId()));
    }

    private Stream<RouteDefinition> getDefinitions(List<CompartmentLane> lanes) {
        return lanes.stream().filter(Route.class::isInstance).map(lane -> this.getDefinition((CompartmentLane)lane));
    }

    private RouteDefinition getDefinition(CompartmentLane lane) {
        Route route = (Route)lane;
        return route.getDefinition();
    }

    private void sortRoutes(List<CompartmentLane> lanes) {
        boolean allAreRoutes = lanes.stream().allMatch(x -> x instanceof Route);
        if (allAreRoutes) {
            lanes.sort((route1, route2) -> {
                RouteDefinition definitionRoute1 = ((Route)route1).getDefinition();
                RouteDefinition definitionRoute2 = ((Route)route2).getDefinition();
                return definitionRoute1.getXmlOrder() - definitionRoute2.getXmlOrder();
            });
        }
    }

    private void configureNextRoute(List<CompartmentLane> lanes) {
        if (lanes.isEmpty()) {
            return;
        }
        Iterator<CompartmentLane> iterator = lanes.iterator();
        CompartmentLane route = iterator.next();
        while (iterator.hasNext()) {
            IElementWrapper routeElement = route.getElement();
            CompartmentLane next = iterator.next();
            IElementWrapper nextElement = next.getElement();
            if (routeElement instanceof IConfigurableElement) {
                ((IConfigurableElement)routeElement).setNextSibling(nextElement);
            }
            if (nextElement instanceof IConfigurableElement) {
                ((IConfigurableElement)nextElement).setPreviousSibling(routeElement);
            }
            route = next;
        }
    }

    public static boolean canDelete(RouteDefinition routeDefinition, List<CompartmentLane> lanes) {
        long routeCount = lanes.stream().filter(Route.class::isInstance).map(Route.class::cast).filter(route -> route.getDefinition().getId().equals(routeDefinition.getId())).count();
        return routeCount > (long)routeDefinition.getMinOccurrence();
    }

    private Optional<PatternEditPart> getPatternEditPart(SplitterEditPart splitter) {
        List children = splitter.getChildren();
        for (EditPart child : children) {
            if (!(child instanceof PatternEditPart)) continue;
            return Optional.of((PatternEditPart)child);
        }
        return Optional.empty();
    }

    @Override
    protected IFigure createFigure() {
        IFigure figure = super.createFigure();
        figure.setBorder((Border)new MarginBorder(7));
        return figure;
    }
}

