/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.OrderedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.command.CloneEntityCommand;
import org.mule.tooling.messageflow.command.MoveEntityCommand;
import org.mule.tooling.messageflow.command.ReparentEntityToANewContainerCommand;
import org.mule.tooling.messageflow.command.TransactionalCompoundCommand;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.CompartmentLaneEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.MuleSelectionEditPolicy;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.util.CloneEntityVisitor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;

public class SelectOnlyEditPolicy
extends OrderedLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new MuleSelectionEditPolicy();
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        NodeDefinition entityDefinition;
        EntityDecorator entityDecorator = (EntityDecorator)child.getParent().getModel();
        if (this.getHost().getModel() == entityDecorator || MessageFlowUtils.isFlowOrSubflowEditPart(child)) {
            return null;
        }
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        ContainerOfMovableEntities oldContainer = this.getOldContainer(child, entityDecorator, messageFlowEntity);
        if (!(messageFlowEntity instanceof UnknownNode) && !this.canGenerateCommand(entityDefinition = ((MessageFlowNode)messageFlowEntity).getDefinition())) {
            return null;
        }
        ReparentEntityToANewContainerCommand cmd = new ReparentEntityToANewContainerCommand((ContainerOfMovableEntities)this.getHost().getModel(), messageFlowEntity, (MuleConfiguration)this.getConfigDecorator().getEntity());
        EditPart compartmentEditPart = child.getParent().getParent();
        if (compartmentEditPart.getParent() != null && compartmentEditPart.getParent() instanceof SplitterEditPart) {
            cmd.setSplitter(true);
        }
        cmd.setRootEditPart((EditPart)compartmentEditPart.getParent().getRoot());
        cmd.setOldCompartment(compartmentEditPart.getModel());
        cmd.setAfterMessageFlowEntity(null);
        Object compartment = this.getHost().getParent().getModel();
        cmd.setCompartment(compartment);
        cmd.setOldContainer(oldContainer);
        return cmd;
    }

    private Command createCloneCommand(EditPart child, EditPart addBefore) {
        NodeDefinition entityDefinition;
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        if (MessageFlowUtils.isFlowOrSubflowEditPart(child)) {
            return null;
        }
        if (!(messageFlowEntity instanceof UnknownNode) && messageFlowEntity instanceof IMessageFlowNode && !this.canGenerateCommand(entityDefinition = ((IMessageFlowNode)messageFlowEntity).getDefinition())) {
            return null;
        }
        ContainerOfMovableEntities model = (ContainerOfMovableEntities)this.getHost().getModel();
        CloneEntityCommand cloneEntityCommand = new CloneEntityCommand(model, messageFlowEntity, new CloneEntityVisitor(model, (MuleConfiguration)this.getConfigDecorator().getEntity(), MuleCorePlugin.getDesignContext().getMuleProject()));
        if (addBefore != null) {
            IMessageFlowEntity afterMessageFlowEntity = ((EntityDecorator)addBefore.getModel()).getEntity();
            cloneEntityCommand.setAfterMessageFlowEntity(afterMessageFlowEntity);
        } else {
            cloneEntityCommand.setAfterMessageFlowEntity(null);
        }
        return cloneEntityCommand;
    }

    protected IMessageFlowEntity getAfterMessageFlowEntity(MessageFlowEntity addBefore, ContainerOfMovableEntities compartmentLane) {
        IMessageFlowEntity addAfter = addBefore == null ? compartmentLane.getLastEntity() : ((CompartmentLaneDecorator)compartmentLane).getEntityBefore((IMessageFlowEntity)addBefore);
        return addAfter;
    }

    protected Command getCloneCommand(ChangeBoundsRequest req) {
        ChangeBoundsRequest request = req;
        List editParts = request.getEditParts();
        TransactionalCompoundCommand command = new TransactionalCompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createCloneCommand(child, this.getInsertionReference((Request)request)));
            if (editParts.size() > 1) {
                this.adjustIndexes(command);
            }
            ++i;
        }
        return command.unwrap();
    }

    protected void adjustIndexes(CompoundCommand compoundCommand) {
        List commands = compoundCommand.getCommands();
        int i = 1;
        while (i < commands.size()) {
            MoveEntityCommand addCommand = (MoveEntityCommand)commands.get(i);
            addCommand.setIndex(((MoveEntityCommand)commands.get(i - 1)).getIndex() + 1);
            ++i;
        }
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        return null;
    }

    protected EditPart getInsertionReference(Request request) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    public ContainerOfMovableEntities getOldContainer(EditPart child, EntityDecorator<?> parentDecorator, IMessageFlowEntity entity) {
        return (ContainerOfMovableEntities)parentDecorator;
    }

    private boolean canGenerateCommand(NodeDefinition entityDefinition) {
        EditPart grandParent;
        EditPart parent;
        CompartmentLaneEditPart msPart = (CompartmentLaneEditPart)this.getHost();
        CompartmentLaneDecorator compartmentLaneDecorator = (CompartmentLaneDecorator)msPart.getModel();
        if (((CompartmentLane)compartmentLaneDecorator.getEntity()).getCompartmentLaneEntries().size() > 0) {
            return false;
        }
        EditPart container = parent = this.getHost().getParent();
        if (parent instanceof CompartmentEditPart && (grandParent = parent.getParent()) instanceof SplitterEditPart) {
            container = grandParent;
        }
        if (container instanceof EntityEditPart) {
            Object parentEntity = ((EntityEditPart)container).getEntity();
            NodeDefinition parentDefinition = MessageFlowUtils.getDefinition(parentEntity);
            if (!entityDefinition.getAcceptedByFilter().accepts(parentDefinition, ModuleManagerNodeDefinitionResolver.get())) {
                return false;
            }
        }
        return true;
    }

    protected MuleConfigurationDecorator getConfigDecorator() {
        MuleConfiguration muleConfiguration = ((EntityEditPart)this.getHost()).getMuleConfiguration();
        return new MuleConfigurationDecorator(muleConfiguration);
    }
}

