/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.List;
import java.util.Optional;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AddCompartmentLaneCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.AddCreateCommandsVisitor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.SplitterLayoutEditPolicy;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;

public class RouterLayoutEditPolicy
extends SplitterLayoutEditPolicy {
    @Override
    protected Command getCreateCommand(CreateRequest request) {
        CompartmentLaneDecorator laneDecorator;
        SplitterNode splitterNode = (SplitterNode)this.getSplitterEditPart().getEntity();
        CompartmentDecorator compartment = this.getSplitterEditPart().getCompartment();
        boolean reusingEmptyLane = true;
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)this.getSplitterEditPart().getMuleConfiguration());
        context.getEntityStack().push(splitterNode);
        CompartmentLane emptyLane = this.getEmptyLane(compartment);
        EntityEditPart<?> emptyLanePart = MessageFlowEditor.findEditPartInRegistry(this.getSplitterEditPart().getViewer(), (IMessageFlowEntity)emptyLane);
        if (emptyLanePart == null) {
            reusingEmptyLane = false;
            context.getEntityStack().push(this.getSplitterNode());
            Optional defaultRoute = splitterNode.getRouteToCreate();
            if (!defaultRoute.isPresent()) {
                return null;
            }
            emptyLane = MessageFlowFactory.createRoute((IFlowTransformerContext)context, (RouteDefinition)((RouteDefinition)defaultRoute.get()));
            laneDecorator = new CompartmentLaneDecorator(emptyLane, true);
        } else {
            laneDecorator = (CompartmentLaneDecorator)emptyLanePart.getEntityDecorator();
        }
        EntityEditPart<?> compEditPart = MessageFlowEditor.findEditPartInRegistry(this.getSplitterEditPart().getViewer(), compartment.getEntity());
        AddCompartmentLaneCommand addLane = new AddCompartmentLaneCommand(compartment, emptyLane);
        Object newObject = request.getNewObject();
        if (newObject instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)newObject;
            if (this.isExceptionStrategyCategory(nodeDefinition)) {
                return null;
            }
            if (!this.canGenerateCommand(nodeDefinition)) {
                return null;
            }
            MessageFlowFactory.configureNextCompartmentLane((Compartment)((Compartment)compartment.getEntity()));
            CompoundCommand command = new CompoundCommand();
            AddCreateCommandsVisitor addCreateCommandsVisitor = new AddCreateCommandsVisitor(command, (CompartmentLaneDecorator<?>)laneDecorator, (EditPart)this.getHost(), (EditPart)compEditPart);
            nodeDefinition.accept((NodeDefinitionVisitor)addCreateCommandsVisitor);
            if (addCreateCommandsVisitor.didAddCommand()) {
                if (!reusingEmptyLane) {
                    command.add((Command)addLane);
                }
                return command;
            }
        }
        return null;
    }

    private CompartmentLane getEmptyLane(CompartmentDecorator compartment) {
        List lanes = compartment.getLanes();
        Optional<Route> emptyRouteMaybe = lanes.stream().filter(Route.class::isInstance).map(Route.class::cast).filter(route -> route.getCompartmentLaneEntries().isEmpty() && route.getDefinition().getMaxOccurrence() > 1).findFirst();
        return emptyRouteMaybe.orElse(null);
    }
}

