/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.messageflow.editpart.IHasContentFigure;
import org.mule.tooling.messageflow.editpart.RouteDefaultBorder;
import org.mule.tooling.messageflow.figure.CompartmentLaneFigure;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;
import org.mule.tooling.messageflow.figure.RouteLaneLayout;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class RouteFigure
extends CompartmentLaneFigure
implements IHasContentFigure {
    public static final int CONTENT_MARGIN = 5;
    private static final int PREFERRED_EMPTY_SIZE = 70;
    private RouteDefaultBorder defaultBorder = new RouteDefaultBorder(this.getBorderColor(), 1);
    private Figure contentFigure;
    private final Figure titleFigure;
    private final Label titleLabel;

    public RouteFigure(CompartmentLane entity) {
        super(entity, true, false);
        ToolbarLayout tbLayout = new ToolbarLayout(false);
        tbLayout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)tbLayout);
        this.titleFigure = new Figure();
        this.titleLabel = new Label();
        super.add((IFigure)this.titleFigure, null, -1);
        this.contentFigure = this.emptyContent();
        RouteLaneLayout layout = new RouteLaneLayout();
        this.contentFigure.setLayoutManager((LayoutManager)layout);
        this.contentFigure.setBorder((Border)new MarginBorder(5));
        super.add((IFigure)this.contentFigure, null, -1);
        this.updateLabel();
    }

    private Figure emptyContent() {
        return new RouteContentFigure();
    }

    @Override
    public IFigure getContentFigure() {
        return this.contentFigure;
    }

    public void showBorder() {
        this.setBorder((Border)this.defaultBorder);
        ToolbarLayout layout = new ToolbarLayout(true);
        this.getTitleFigure().setLayoutManager((LayoutManager)layout);
        MarginBorder titleMargin = new MarginBorder(0, 5, 0, 0);
        titleMargin = new MarginBorder(2, 5, 0, 0);
        this.getTitleLabel().setForegroundColor(ThemeUtils.getCurrentTheme().getForegroundColor());
        this.getTitleFigure().setBackgroundColor(ThemeUtils.getCurrentTheme().getBackgroundColor());
        this.getTitleFigure().setOpaque(true);
        this.getTitleFigure().setBorder((Border)titleMargin);
        if (!this.getTitleFigure().getChildren().contains(this.getTitleLabel())) {
            this.getTitleFigure().add((IFigure)this.getTitleLabel());
            this.applyStyle();
        }
        this.getTitleLabel().setVisible(true);
        this.getTitleLabel().invalidate();
        this.applyStyle();
    }

    public void hideBorder() {
        MarginBorder margin = new MarginBorder(5);
        this.setBorder((Border)margin);
    }

    protected Color getBorderColor() {
        if (ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme) {
            return new Color((Device)Display.getCurrent(), new RGB(72, 72, 72));
        }
        return FigureColorRegistry.getDefault().get("container.border");
    }

    @Override
    public void updateImageFigure() {
        this.updateLabel();
        super.updateImageFigure();
    }

    protected void updateLabel() {
        String title = this.getTitle();
        this.getTitleLabel().setText(title);
    }

    private String getTitle() {
        Route route = (Route)this.getEntity();
        String routeName = route.getDisplayName();
        return StringUtils.isEmpty((String)routeName) ? route.getName() : routeName;
    }

    public RouteDefaultBorder getLineBorder() {
        return this.defaultBorder;
    }

    public void add(IFigure figure, Object constraint, int index) {
        this.contentFigure.add(figure, constraint, index);
    }

    public void remove(IFigure figure) {
        this.contentFigure.remove(figure);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        ImageDescriptor decoratorDescriptor = this.getDecorationImageDescriptor();
        this.paintDecorator(graphics, decoratorDescriptor);
    }

    private void paintDecorator(Graphics graphics, ImageDescriptor decorator) {
        if (decorator != null) {
            Image decoratorImage = decorator.createImage();
            Point pos = this.getDecoratorPosition(decoratorImage);
            graphics.drawImage(decoratorImage, pos.x, pos.y);
            decoratorImage.dispose();
        }
    }

    private Point getDecoratorPosition(Image decoratorImage) {
        int x = this.getBounds().x + this.getBounds().width - decoratorImage.getBounds().width + 3;
        int y = this.getTitleFigure().getBounds().y - 4;
        return new Point(x, y);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension pref = super.getPreferredSize(wHint, hHint);
        Dimension dimension = new Dimension(Math.max(70, pref.width), Math.max(70, pref.height));
        return dimension;
    }

    @Override
    protected String getDefaultTitleColorString() {
        return "container.title";
    }

    public Figure getTitleFigure() {
        return this.titleFigure;
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public Insets getInsets() {
        if (this.getDecorationImageDescriptor() != null) {
            return super.getInsets().add(new Insets(0, 0, 0, 12));
        }
        return super.getInsets();
    }

    private class RouteContentFigure
    extends Figure {
        private RouteContentFigure() {
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            if (this.getChildren().isEmpty()) {
                return new Dimension(70, 70);
            }
            Dimension preferredSize = super.getPreferredSize(wHint, hHint);
            int width = Math.max(RouteFigure.this.getTitleFigure().getPreferredSize().width, preferredSize.width);
            Dimension dimension = new Dimension(Math.max(70, width), preferredSize.height);
            return dimension;
        }
    }
}

