/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.IEntityEditPartRequestHandler;

public class RequestHandlerManager {
    private List<IEntityEditPartRequestHandler> requestHandler;
    private static RequestHandlerManager defaultManager = new RequestHandlerManager();

    public RequestHandlerManager() {
        this.init();
    }

    public void init() {
        IConfigurationElement[] configurationElementsFor;
        this.requestHandler = new ArrayList<IEntityEditPartRequestHandler>();
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.requesthandler");
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                this.requestHandler.add((IEntityEditPartRequestHandler)iConfigurationElement.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public boolean handleReadAccessRequest(EntityEditPart<?> editPart, Request request) {
        for (IEntityEditPartRequestHandler handler : this.requestHandler) {
            boolean noOtherShouldBeCalled;
            if (!handler.handlesRequestFor(editPart) || !(noOtherShouldBeCalled = handler.handleReadAccessRequest(editPart, request))) continue;
            return true;
        }
        return false;
    }

    public boolean handleWriteAccessRequest(EntityEditPart<?> editPart, Request request, CompoundCommand command) {
        for (IEntityEditPartRequestHandler handler : this.requestHandler) {
            boolean noOtherShouldBeCalled;
            if (!handler.handlesRequestFor(editPart) || !(noOtherShouldBeCalled = handler.handleWriteAccessRequest(editPart, request, command))) continue;
            return true;
        }
        return false;
    }

    public static RequestHandlerManager getDefault() {
        return defaultManager;
    }
}

