/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import com.google.common.base.Optional;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.editpart.ConnectorEditPart;
import org.mule.tooling.messageflow.editpart.EndcapAnchor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.FixPointAnchor;
import org.mule.tooling.messageflow.editpart.PatternContainerEditPolicy;
import org.mule.tooling.messageflow.events.FigureCreatedEvent;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.NodeFigure;
import org.mule.tooling.messageflow.figure.PatternFigure;
import org.mule.tooling.messageflow.figure.RequestResponseFigure;
import org.mule.tooling.messageflow.figure.SplitterPatternFigure;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.Connector;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.model.messageflow.decorator.PatternDecorator;
import org.mule.tooling.model.messageflow.decorator.SplitterDecorator;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.utils.eventbus.IEvent;

public class PatternEditPart
extends EntityEditPart<PatternNode>
implements NodeEditPart {
    private boolean handlesResponse = false;
    private boolean casusesSplit = false;

    public PatternEditPart(PatternDecorator decorator) {
        super(decorator);
    }

    @Override
    public void activate() {
        super.activate();
        this.updatePatternBehaviour();
    }

    public void updatePatternBehaviour() {
        try {
            NodeDefinition nodeDef = ((PatternNode)this.getEntity()).getDefinition();
            if (nodeDef instanceof PatternDefinition) {
                PatternDefinition patternDef = (PatternDefinition)nodeDef;
                this.handlesResponse = patternDef.isProcessesResponse() && this.getParentDecorator().isShowResponse();
                this.casusesSplit = patternDef.isCausesSplit();
            } else if (nodeDef instanceof SplitterDefinition) {
                this.casusesSplit = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected IFigure createFigure() {
        this.updatePatternBehaviour();
        EntityFigure result = null;
        if (this.casusesSplit) {
            SplitterNode splitter = (SplitterNode)((SplitterDecorator)this.getParent().getModel()).getEntity();
            result = new SplitterPatternFigure((PatternNode)this.getEntity(), splitter);
        } else {
            result = this.handlesResponse ? new RequestResponseFigure((MessageFlowEntity)this.getEntity(), new PatternFigure((PatternNode)this.getEntity())) : new PatternFigure((PatternNode)this.getEntity());
        }
        this.fireFigureCreatedEvent(result);
        return result;
    }

    private void fireFigureCreatedEvent(EntityFigure<?> figure) {
        MulePath entityPath = this.getMuleConfiguration().getPathFor(this.getEntity());
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new FigureCreatedEvent(figure, entityPath));
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PatternContainerEditPolicy());
    }

    @Override
    public void updateFigure() {
        IFigure figure = this.getFigure();
        if (figure instanceof NodeFigure) {
            NodeFigure nodeFigure = (NodeFigure)figure;
            nodeFigure.updateName();
            nodeFigure.updateDescription();
        } else if (figure instanceof RequestResponseFigure) {
            NodeFigure rrFigure = ((RequestResponseFigure)figure).getRequestFigure();
            rrFigure.updateName();
            rrFigure.updateDescription();
        } else if (figure instanceof SplitterPatternFigure) {
            SplitterPatternFigure splitterFigure = (SplitterPatternFigure)figure;
            splitterFigure.getPatternFigure().updateName();
            splitterFigure.getPatternFigure().updateDescription();
        }
        super.updateFigure();
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        AbstractConnectionAnchor retValue = null;
        retValue = this.casusesSplit ? new EndcapAnchor(this.getFigure()) : new FixPointAnchor(this.getPatternFigure(connection));
        return retValue;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEdit) {
        return new FixPointAnchor(this.getPatternFigure(connEdit));
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    public boolean isSelectable() {
        return !this.casusesSplit;
    }

    public void updateOutbound() {
        this.refreshSourceConnections();
    }

    protected IFigure getPatternFigure(ConnectionEditPart connEdit) {
        ConnectorType type;
        Optional<Connector> connector = this.getConnector(connEdit);
        ConnectorType connectorType = type = connector.isPresent() ? ((Connector)connector.get()).getType() : ConnectorType.REQUEST_FLOW;
        if (this.handlesResponse) {
            RequestResponseFigure requestResponseFigure = (RequestResponseFigure)this.getFigure();
            if (type == ConnectorType.REQUEST_FLOW) {
                NodeFigure requestFigure = ((RequestResponseFigure)this.getFigure()).getRequestFigure();
                return requestFigure.getImageFigure();
            }
            return requestResponseFigure.getResponseFigure();
        }
        return this.getFigure();
    }

    private Optional<Connector> getConnector(ConnectionEditPart connEdit) {
        if (connEdit instanceof ConnectorEditPart) {
            ConnectorEditPart connectorEditPart = (ConnectorEditPart)connEdit;
            return Optional.of((Object)connectorEditPart.getConnector());
        }
        return Optional.absent();
    }

    public CompartmentLaneDecorator<?> getParentDecorator() {
        return (CompartmentLaneDecorator)this.getParent().getModel();
    }

    @Override
    public void deactivate() {
        if (this.getFigure() instanceof NodeFigure) {
            NodeFigure figure = (NodeFigure)this.getFigure();
            figure.deactivate();
        }
        super.deactivate();
    }
}

