/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.command.IMessageFlowEntityFactory;
import org.mule.tooling.messageflow.command.MessageFlowEntityAdapterManager;
import org.mule.tooling.messageflow.command.MessageFlowEntityFactoryManager;
import org.mule.tooling.messageflow.command.MessageFlowNodeCreateCommand;
import org.mule.tooling.messageflow.command.ReparentEntityToANewContainerCommand;
import org.mule.tooling.messageflow.editpart.AbstractCompartmentLaneLayoutEditPolicy;
import org.mule.tooling.messageflow.editpart.MuleSelectionEditPolicy;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.figure.NestedContainerFigure;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.NestedContainerDecorator;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.CardinalityFilter;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;

public class NestedContainerEditPolicy
extends AbstractCompartmentLaneLayoutEditPolicy {
    private NestedContainerDefinition nestedContainerDefinition;
    private NestedContainerDecorator nestedContainer;
    private MessageFlowEntityFactoryManager messageFlowEntityFactoryManager = new MessageFlowEntityFactoryManager();
    private MuleConfiguration muleConfiguration;

    public NestedContainerEditPolicy(MuleConfiguration muleConfiguration, NestedContainerDefinition definition, NestedContainerDecorator nestedContainer) {
        this.muleConfiguration = muleConfiguration;
        this.nestedContainerDefinition = definition;
        this.nestedContainer = nestedContainer;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new MuleSelectionEditPolicy();
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object newObject = request.getNewObject();
        if (newObject instanceof NodeDefinition) {
            NodeDefinition newElementDefinition = (NodeDefinition)newObject;
            MessageFlowEntity beforeMessageFlowEntity = this.getBeforeMessageFlowEntity(request);
            IMessageFlowEntity afterMessageFlowEntity = this.getAfterMessageFlowEntity((IMessageFlowEntity)beforeMessageFlowEntity, (ContainerOfMovableEntities)this.nestedContainer);
            IMessageFlowEntityFactory factory = this.messageFlowEntityFactoryManager.getFactory(this.getEntity(), newElementDefinition);
            IMessageFlowNode createdNode = factory.create(this.muleConfiguration, (IMessageFlowEntity)this.getEntity(), newElementDefinition, (IMessageFlowEntity)beforeMessageFlowEntity, afterMessageFlowEntity);
            if (createdNode != null) {
                NodeDefinition createdObjectDefinition = createdNode.getDefinition();
                boolean childAccepted = this.validateAcceptsFilter(createdObjectDefinition);
                boolean containerAccepted = createdObjectDefinition.getAcceptedByFilter().accepts((IMessageFlowNode)this.nestedContainer.getEntity(), (NodeDefinition)this.nestedContainerDefinition, ModuleManagerNodeDefinitionResolver.get());
                boolean containerAccepts = true;
                if (!(this.nestedContainerDefinition.getAcceptsFilter() instanceof CardinalityFilter)) {
                    containerAccepts = this.nestedContainerDefinition.getAcceptsFilter().accepts(createdNode, newElementDefinition, ModuleManagerNodeDefinitionResolver.get());
                }
                boolean locationAccepted = newElementDefinition.getLocationFilter().accepts((IMessageFlowEntity)beforeMessageFlowEntity, afterMessageFlowEntity);
                if (childAccepted && containerAccepted && containerAccepts && locationAccepted) {
                    return new MessageFlowNodeCreateCommand((CompartmentLaneDecorator<? extends CompartmentLane>)this.nestedContainer, createdNode, newElementDefinition, (IMessageFlowEntity)beforeMessageFlowEntity);
                }
            }
        }
        return null;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        boolean locationAccepted;
        EntityDecorator entityDecorator = (EntityDecorator)child.getParent().getModel();
        if (this.getHost().getModel() == entityDecorator || MessageFlowUtils.isFlowOrSubflowEditPart(child)) {
            return null;
        }
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        if (messageFlowEntity instanceof UnknownNode) {
            return null;
        }
        String movedElementType = MessageFlowUtils.getType(messageFlowEntity);
        if (MessageFlowEntityAdapterManager.get().hasAdapter((NodeDefinition)this.nestedContainerDefinition, messageFlowEntity)) {
            IMessageFlowEntity adapted = MessageFlowEntityAdapterManager.get().getAdapter((NodeDefinition)this.nestedContainerDefinition, messageFlowEntity).adapt(this.muleConfiguration, messageFlowEntity);
            movedElementType = MessageFlowUtils.getType(adapted);
        }
        ContainerOfMovableEntities compartmentLaneDecorator = (ContainerOfMovableEntities)this.getHost().getModel();
        IMessageFlowEntity addBeforeEntity = after != null ? ((EntityDecorator)after.getModel()).getEntity() : null;
        IMessageFlowEntity addAfterEntity = this.getAfterMessageFlowEntity(addBeforeEntity, compartmentLaneDecorator);
        NodeDefinition movedElementDefinition = null;
        movedElementDefinition = messageFlowEntity instanceof MessageFlowNode ? ((MessageFlowNode)messageFlowEntity).getDefinition() : MuleCorePlugin.getModuleManager().getDefinition(movedElementType, false);
        if (!ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity) && movedElementDefinition == null) {
            return null;
        }
        boolean bl = locationAccepted = ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity) || movedElementDefinition.getLocationFilter().accepts(addBeforeEntity, addAfterEntity);
        if (locationAccepted) {
            boolean containerAccepted;
            boolean bl2 = containerAccepted = ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity) || movedElementDefinition.getAcceptedByFilter().accepts((IMessageFlowNode)this.nestedContainer.getEntity(), (NodeDefinition)this.nestedContainerDefinition, ModuleManagerNodeDefinitionResolver.get());
            if (containerAccepted) {
                boolean acceptsFilter;
                boolean containerAccepts = true;
                if (!(this.nestedContainerDefinition.getAcceptsFilter() instanceof CardinalityFilter)) {
                    IMessageFlowNode movedElementNode = (IMessageFlowNode)((EntityDecorator)child.getModel()).getEntity();
                    boolean bl3 = containerAccepts = ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity) || this.nestedContainerDefinition.getAcceptsFilter().accepts(movedElementNode, movedElementDefinition, ModuleManagerNodeDefinitionResolver.get());
                }
                if (containerAccepts && (acceptsFilter = this.validateAcceptsFilter(movedElementDefinition))) {
                    ReparentEntityToANewContainerCommand cmd = new ReparentEntityToANewContainerCommand((ContainerOfMovableEntities)this.getHost().getModel(), messageFlowEntity, this.getMuleConfiguration());
                    if (after != null) {
                        IMessageFlowEntity afterMessageFlowEntity = ((EntityDecorator)after.getModel()).getEntity();
                        cmd.setAfterMessageFlowEntity(afterMessageFlowEntity);
                    } else {
                        cmd.setAfterMessageFlowEntity(null);
                    }
                    cmd.setOldContainer((ContainerOfMovableEntities)entityDecorator);
                    EditPart compartmentEditPart = child.getParent().getParent();
                    if (compartmentEditPart.getParent() != null && compartmentEditPart.getParent() instanceof SplitterEditPart) {
                        cmd.setSplitter(true);
                    }
                    cmd.setRootEditPart((EditPart)compartmentEditPart.getRoot());
                    cmd.setOldCompartment(compartmentEditPart.getModel());
                    Object compartment = this.getParent().getModel();
                    cmd.setCompartment(compartment);
                    return cmd;
                }
            }
        }
        return null;
    }

    @Override
    public boolean canGenerateCommand(NodeDefinition newNode) {
        return super.canGenerateCommand(newNode) && this.validateAcceptsFilter(newNode);
    }

    protected boolean validateAcceptsFilter(NodeDefinition newNode) {
        if (newNode == null) {
            return true;
        }
        return this.nestedContainerDefinition.getAcceptsFilter().accepts((IMessageFlowNode)this.nestedContainer.getEntity(), newNode, ModuleManagerNodeDefinitionResolver.get());
    }

    protected IFigure getHostFigure() {
        return ((NestedContainerFigure)this.getHost().getFigure()).getContentFigure();
    }

    public GraphicalEditPart getHost() {
        return super.getHost();
    }

    @Override
    protected int getTopMarginSize() {
        return 20;
    }

    public NestedContainerDefinition getNestedContainerDefinition() {
        return this.nestedContainerDefinition;
    }

    public NestedContainerDecorator getNestedContainer() {
        return this.nestedContainer;
    }

    public MessageFlowEntityFactoryManager getMessageFlowEntityFactoryManager() {
        return this.messageFlowEntityFactoryManager;
    }

    @Override
    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }
}

