/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.editpart.ContainerUpdateParticipant;
import org.mule.tooling.messageflow.editpart.ContainerUpdateParticipantManager;
import org.mule.tooling.messageflow.editpart.DefaultChildrenCreator;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.IMuleProjectAwareEditPart;
import org.mule.tooling.messageflow.editpart.MuleSelectionEditPolicy;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPolicy;
import org.mule.tooling.messageflow.editpolicy.ContainerEditPolicyFactoryManager;
import org.mule.tooling.messageflow.editpolicy.EditPolicyFactory;
import org.mule.tooling.messageflow.figure.FigureFactory;
import org.mule.tooling.messageflow.layout.ContainerChildrenCreatorManager;
import org.mule.tooling.messageflow.layout.NestedContainerChildrenCreator;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.NestedContainerDecorator;
import org.mule.tooling.model.module.NestedContainerDefinition;

public class NestedContainerEditPart
extends EntityEditPart<NestedContainer>
implements IMuleProjectAwareEditPart {
    private IMuleProject project;
    private List<EntityDecorator<?>> children;
    private NestedContainerDecorator nestedContainerDecorator;
    private FigureFactory<NestedContainer> figureFactory;
    private final NestedContainerChildrenCreator childrenCreator;

    public NestedContainerEditPart(NestedContainerDecorator nestedContainerDecorator, IMuleProject project, FigureFactory<NestedContainer> figureFactory) {
        super(nestedContainerDecorator);
        this.nestedContainerDecorator = nestedContainerDecorator;
        this.project = project;
        this.figureFactory = figureFactory;
        NestedContainerDefinition definition = this.getDefinition();
        String childrenCreatorId = definition.getChildrenCreatorId();
        Optional<NestedContainerChildrenCreator> childrenCreator = ContainerChildrenCreatorManager.instance().getChildrenCreator(childrenCreatorId);
        this.childrenCreator = (NestedContainerChildrenCreator)childrenCreator.or((Object)DefaultChildrenCreator.instance);
    }

    @Override
    public IMuleProject getMuleProject() {
        return this.project;
    }

    @Override
    protected IFigure createFigure() {
        return this.figureFactory.create((NestedContainer)this.getEntity());
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        Optional<EditPolicyFactory> editPolicyFactory = ContainerEditPolicyFactoryManager.instance().getEditPolicyFactory(this.getDefinition().getEditPolicyFactoryId());
        NestedContainerEditPolicy editPolicy = editPolicyFactory.isPresent() ? ((EditPolicyFactory)editPolicyFactory.get()).create(this.getMuleConfiguration(), this.getDefinition(), this.nestedContainerDecorator) : this.createDefaultEditPolicy();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)editPolicy);
        if ("http://www.mulesoft.org/schema/mule/core/error-handler".equals(this.getDefinition().getId())) {
            MuleSelectionEditPolicy selectionPolicy = new MuleSelectionEditPolicy();
            this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)selectionPolicy);
        }
    }

    private NestedContainerEditPolicy createDefaultEditPolicy() {
        return new NestedContainerEditPolicy(this.getMuleConfiguration(), this.getDefinition(), this.nestedContainerDecorator);
    }

    private NestedContainerDefinition getDefinition() {
        return (NestedContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition(((NestedContainer)this.getEntity()).getType());
    }

    @Override
    public void update(Observable model, Object propertyName) {
        super.update(model, propertyName);
        if (propertyName.equals("properties")) {
            this.refresh();
        }
        if ("entities".equals(propertyName)) {
            this.cleanChildren();
            this.refreshChildren();
        }
        String updateParticipantId = this.getDefinition().getUpdateParticipantId();
        Optional<ContainerUpdateParticipant> updateParticipant = ContainerUpdateParticipantManager.instance().getUpdateParticipant(updateParticipantId);
        if (updateParticipant.isPresent()) {
            ((ContainerUpdateParticipant)updateParticipant.get()).update(model, propertyName, this);
        }
    }

    public void cleanChildren() {
        this.children = null;
    }

    protected List<EntityDecorator<?>> getModelChildren() {
        if (this.children == null) {
            this.children = this.childrenCreator.createChildren(this);
        }
        return this.children;
    }

    public void refreshChildren() {
        super.refreshChildren();
        for (EntityEditPart entity : this.getChildren()) {
            entity.updateConnections();
        }
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateRequest) {
            return this;
        }
        if (request instanceof ChangeBoundsRequest) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public NestedContainerDecorator getNestedContainerDecorator() {
        return this.nestedContainerDecorator;
    }

    public ContainerEditPart getParentContainer() {
        return (ContainerEditPart)this.getParent();
    }
}

